see.weib.tck<-function ()
{

tclServiceMode(TRUE)
    if (!exists("slider.env"))
        slider.env <- NULL; suppressWarnings(rm(slider.env)); slider.env <<- new.env()# Dummy to trick R CMD check
    theta <- 1
    beta<-1
    assign("theta", tclVar(theta), envir = slider.env)
    assign("beta", tclVar(beta), envir = slider.env)
    xmin <- 0
    assign("xmin", tclVar(xmin), envir = slider.env)
    xmax <- 30
    assign("xmax", tclVar(xmax), envir = slider.env)

    if(names(dev.cur()) == "RStudioGD") dev.new(noRStudioGD = TRUE)

   norm.refresh <- function(...) {
        theta <- as.numeric(evalq(tclvalue(theta), envir = slider.env))
        beta <- as.numeric(evalq(tclvalue(beta), envir = slider.env))
        xmin <- as.numeric(evalq(tclvalue(xmin), envir = slider.env))
        xmax <- as.numeric(evalq(tclvalue(xmax), envir = slider.env))
        xx <- seq(xmin, xmax, length = 500)
        yy <- dweibull(xx, theta, beta)
        dev.hold()
        plot(xx, yy, type = "l", xlim = c(xmin, xmax), xlab=expression(italic(x)),ylab=expression(paste(italic(f),"(",italic(x),")", sep = "")))
        mtext(bquote(paste(italic(X), " ~ ", italic(WEI), "(", .(beta), ", ", .(theta),")", sep = "")), side = 3, line = 1)
        dev.flush()
                    }
    m <- tktoplevel()
  tkwm.title(m, "WEI(\u03b8, \u03b2)")
    tkpack(tklabel(m,text="      Visualizing the Weibull Distribution      "))
    tkwm.geometry(m, "+0+0")

    tkpack(fr <- tkframe(m), side = "top")
    tkpack(tklabel(fr, text = '\u03b8', font=c("Helvetica","9","italic"), width = "20"),
        side = "right")
    tkpack(sc <- tkscale(fr, command = norm.refresh, from = 0.1,
        to = 15, orient = "horiz", resolution = 0.1, showvalue = TRUE),
        side = "left")
    assign("sc", sc, envir = slider.env)
    evalq(tkconfigure(sc, variable = theta), envir = slider.env)

    tkpack(fr <- tkframe(m), side = "top")
    tkpack(tklabel(fr, text = '\u03b2',font=c("Helvetica","9","italic"), width = "20"), side = "right")
    tkpack(sc <- tkscale(fr, command = norm.refresh, from = 0.1,
        to = 15, orient = "horiz", resolution = 0.1, showvalue = TRUE),
        side = "left")
    assign("sc", sc, envir = slider.env)
    evalq(tkconfigure(sc, variable = beta), envir = slider.env)

    tkpack(fr <- tkframe(m), side = "top")
    tkpack(tklabel(fr, text = "Xmin:", width = 6), side = "left")
    tkpack(e <- tkentry(fr, width = 8), side = "left")
    assign("e", e, envir = slider.env)
    evalq(tkconfigure(e, textvariable = xmin), envir = slider.env)
    tkpack(tklabel(fr, text = "Xmax:", width = 6), side = "left")
    tkpack(e <- tkentry(fr, width = 8), side = "left")
    assign("e", e, envir = slider.env)
    evalq(tkconfigure(e, textvariable = xmax), envir = slider.env)
    tkpack(tkbutton(m, text = "Refresh", command = norm.refresh),
        side = "left")
    tkpack(tkbutton(m, text = "Exit", command = function() tkdestroy(m)),
        side = "right")
}



see.weibcdf.tck<-function (){
#old.par <- par(no.readonly = TRUE)
tclServiceMode(TRUE)
    if (!exists("slider.env"))
        slider.env <- NULL; suppressWarnings(rm(slider.env)); slider.env <<- new.env()# Dummy to trick R CMD check
    theta <- 1
    beta<-1
    assign("theta", tclVar(theta), envir = slider.env)
    assign("beta", tclVar(beta), envir = slider.env)
    xmin <- 0
    assign("xmin", tclVar(xmin), envir = slider.env)
    xmax <- 30
    assign("xmax", tclVar(xmax), envir = slider.env)

   dev.new(height=4,width=8,noRStudioGD = TRUE);par(mar=c(4.4,4.5,1,0.5),cex=.85, oma = c(0,0,1.5,0)); layout(matrix(c(1,2), 1, 2, byrow = TRUE))
   norm.refresh <- function(...) {
        theta <- as.numeric(evalq(tclvalue(theta), envir = slider.env))
        beta <- as.numeric(evalq(tclvalue(beta), envir = slider.env))
        xmin <- as.numeric(evalq(tclvalue(xmin), envir = slider.env))
        xmax <- as.numeric(evalq(tclvalue(xmax), envir = slider.env))
        xx <- seq(xmin, xmax, length = 500)
        yy <- dweibull(xx, theta, beta)
        y1<- pweibull(xx, theta, beta)
        dev.hold()
        plot(xx, yy, type = "l", xlim = c(xmin, xmax),xlab=expression(italic(x)),ylab=expression(paste(italic(f),"(",italic(x),")", sep = "")))
        plot(xx, y1, type = "l", xlim = c(xmin, xmax), xlab=expression(italic(x)),ylab=expression(paste(italic(F),"(",italic(x),")", sep = "")))
        mtext(bquote(paste(italic(X), " ~ ", italic(WEI), "(", .(beta), ", ", .(theta),")", sep = "")), outer = TRUE, side = 3, cex = .9)
        dev.flush()
                    }
    m <- tktoplevel()
 tkwm.title(m, "WEI(\u03b8, \u03b2)")
    tkpack(tklabel(m,text="      Visualizing the Weibull Distribution      "))
    tkwm.geometry(m, "+0+0")

    tkpack(fr <- tkframe(m), side = "top")
    tkpack(tklabel(fr, text = '\u03b8', font=c("Helvetica","9","italic"), width = "20"),
        side = "right")
    tkpack(sc <- tkscale(fr, command = norm.refresh, from = 0.1,
        to = 15, orient = "horiz", resolution = 0.1, showvalue = TRUE),
        side = "left")
    assign("sc", sc, envir = slider.env)
    evalq(tkconfigure(sc, variable = theta), envir = slider.env)

    tkpack(fr <- tkframe(m), side = "top")
    tkpack(tklabel(fr, text = '\u03b2',font=c("Helvetica","9","italic"), width = "20"), side = "right")
    tkpack(sc <- tkscale(fr, command = norm.refresh, from = 0.1,
        to = 15, orient = "horiz", resolution = 0.1, showvalue = TRUE),
        side = "left")
    assign("sc", sc, envir = slider.env)
    evalq(tkconfigure(sc, variable = beta), envir = slider.env)

    tkpack(fr <- tkframe(m), side = "top")
    tkpack(tklabel(fr, text = "Xmin:", width = 6), side = "left")
    tkpack(e <- tkentry(fr, width = 8), side = "left")
    assign("e", e, envir = slider.env)
    evalq(tkconfigure(e, textvariable = xmin), envir = slider.env)
    tkpack(tklabel(fr, text = "Xmax:", width = 6), side = "left")
    tkpack(e <- tkentry(fr, width = 8), side = "left")
    assign("e", e, envir = slider.env)
    evalq(tkconfigure(e, textvariable = xmax), envir = slider.env)
    tkpack(tkbutton(m, text = "Refresh", command = norm.refresh),
        side = "left")
    tkpack(tkbutton(m, text = "Exit", command = function() tkdestroy(m)),
        side = "right")
  #  on.exit(par(old.par))
  }
