% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asciicast.R
\name{record}
\alias{record}
\title{Record an asciinema screencast}
\usage{
record(
  script,
  typing_speed = NULL,
  empty_wait = NULL,
  cols = NULL,
  rows = NULL,
  title = NULL,
  timestamp = NULL,
  env = NULL,
  idle_time_limit = NULL,
  allow_errors = TRUE,
  timeout = NULL,
  start_wait = NULL,
  end_wait = NULL,
  record_env = NULL,
  startup = NULL,
  echo = TRUE,
  process = NULL
)
}
\arguments{
\item{script}{Path of an R script to record. It can also be a readable
R connection or URL, as it is passed to \code{\link[base:readLines]{base::readLines()}}.}

\item{typing_speed}{Average typing speed, per keypress, in seconds.}

\item{empty_wait}{How long to wait for empty lines in the script file,
in seconds.}

\item{cols}{Width of the terminal, in number of characters.}

\item{rows}{Height of the terminal, in number of characters. If it the
string \code{"auto"}, then it will be determined automatically, by including
all output on the screen.}

\item{title}{Title of the cast, this is included in the cast JSON file.}

\item{timestamp}{Time stamp of the recording, defaults to \code{Sys.time()},
this is included in the cast JSON file.}

\item{env}{Environment variables to include in the case JSON file.
Defaults to \code{list(TERM = "xterm-256color", SHELL = "/bin/zsh")}.}

\item{idle_time_limit}{Time limit for the cast not printing anything,
in seconds. By default there is no limit.}

\item{allow_errors}{Whether to cast errors properly. If this is set to
\code{TRUE}, then asciicast overwrites the \code{"error"} option. Only change
this if you know what you are doing.}

\item{timeout}{Idle timeout, in seconds If the R subprocess running
the recording does not answer within this limit, it is killed and the
recording stops. Update this for slow running code, that produces no
output as it runs.}

\item{start_wait}{Delay at the beginning, in seconds.}

\item{end_wait}{Delay at the very end, in seconds.}

\item{record_env}{Environment variables to set for the R subprocess.}

\item{startup}{Quoted language object to run in the subprocess before
starting the recording.}

\item{echo}{Whether to echo the input to the terminal. If \code{FALSE}, then
only the output is shown.}

\item{process}{A processx subprocess to run the cast in. By default a
new subprocess is started. You can reuse a process by calling
\code{\link[=asciicast_start_process]{asciicast_start_process()}} first, and supplying the returned process
here.}
}
\value{
An \code{asciicast} object, write this to
file with \code{\link[=write_json]{write_json()}}.
}
\description{
Record an asciinema screencast
}
\examples{
\dontshow{if (asciicast:::is_recording_supported() && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
script <- system.file("examples", "hello.R", package = "asciicast")
cast <- record(script)
play(cast)
\dontshow{\}) # examplesIf}
}
\seealso{
Other asciicast functions: 
\code{\link{asciicast-package}},
\code{\link{asciicast_start_process}()},
\code{\link{read_cast}()},
\code{\link{write_json}()}
}
\concept{asciicast functions}
