% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_create.R
\name{assert_create_chain}
\alias{assert_create_chain}
\title{Create Chains of Assertions}
\usage{
assert_create_chain(...)
}
\arguments{
\item{...}{assertion functions created by \code{assert_create()}.}
}
\value{
A single assertion function that calls each of the input functions in the order they are supplied.
}
\description{
Combine multiple assertion functions created by \code{assert_create()} into a single assertion function with diverse failure modes and error messages.
}
\examples{
# Create an assertion function that checks for both positive integers and even values
assert_string <- assert_create_chain(
  assert_create(is.character, '{{arg_name}} must be a character'),
  assert_create(function(x){{ length(x)==1 }}, '{{arg_name}} must be length 1')
  )

# Use the assertion function to check a valid value
assert_string("String")

# Use the assertion function to check an invalid value
try({
assert_string(3)
# Output: Error: '3' must be a character
})
}
