% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-file.R, R/is-file.R
\name{assert_all_are_libraries}
\alias{assert_all_are_libraries}
\alias{assert_any_are_libraries}
\alias{is_library}
\title{Is the directory a known R library?}
\usage{
assert_all_are_libraries(x, severity = getOption("assertive.severity",
  "stop"))

assert_any_are_libraries(x, severity = getOption("assertive.severity",
  "stop"))

is_library(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Directory paths}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_library} returns \code{TRUE} if and only if the input
paths are known R package libraries.  That is, they must be paths
returned by \code{.libPaths}.
}
\description{
Checks to see if the input directories are known R libraries.
}
\note{
Input paths are converted to character, and then normalized using
\code{normalizePaths}.
}
\examples{
is_library(c(.libPaths(), R.home()))
}

