% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-matrix.R, R/is-matrix.R
\name{assert_is_zero_matrix}
\alias{assert_is_zero_matrix}
\alias{is_zero_matrix}
\title{Is the input a zero matrix}
\usage{
assert_is_zero_matrix(x, tol = 100 * .Machine$double.eps,
  severity = getOption("assertive.severity", "stop"))

is_zero_matrix(x, tol = 100 * .Machine$double.eps,
  .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{tol}{Absolute values smaller than \code{tol} are not considered.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{TRUE} if the input is all zeroes (after coercion to be a 
matrix).
}
\description{
Checks that the input is a matrix of zeroes.
}
\examples{
x <- matrix(numeric(9), 3)
is_zero_matrix(x)
x[1, 1] <- 100 * .Machine$double.eps
is_zero_matrix(x)
x[2, 2] <- 101 * .Machine$double.eps
is_zero_matrix(x)
}
