% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-infinity-nan.R, R/is-infinity-nan.R
\name{assert_all_are_finite}
\alias{assert_all_are_finite}
\alias{assert_all_are_infinite}
\alias{assert_all_are_negative_infinity}
\alias{assert_all_are_positive_infinity}
\alias{assert_any_are_finite}
\alias{assert_any_are_infinite}
\alias{assert_any_are_negative_infinity}
\alias{assert_any_are_positive_infinity}
\alias{is_finite}
\alias{is_infinite}
\alias{is_negative_infinity}
\alias{is_positive_infinity}
\title{Are the inputs (in)finite?}
\usage{
assert_all_are_finite(x, severity = getOption("assertive.severity", "stop"))

assert_any_are_finite(x, severity = getOption("assertive.severity", "stop"))

assert_all_are_infinite(x, severity = getOption("assertive.severity", "stop"))

assert_any_are_infinite(x, severity = getOption("assertive.severity", "stop"))

assert_all_are_negative_infinity(x, severity = getOption("assertive.severity",
  "stop"))

assert_any_are_negative_infinity(x, severity = getOption("assertive.severity",
  "stop"))

assert_all_are_positive_infinity(x, severity = getOption("assertive.severity",
  "stop"))

assert_any_are_positive_infinity(x, severity = getOption("assertive.severity",
  "stop"))

is_finite(x, .xname = get_name_in_parent(x))

is_infinite(x, .xname = get_name_in_parent(x))

is_negative_infinity(x, .xname = get_name_in_parent(x))

is_positive_infinity(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_finite} wraps \code{is.finite}, showing the 
names of the inputs in the answer. \code{is_infinite} works 
likewise for \code{is.infinite}.  The \code{assert_*} functions 
return nothing but throw an error if the corresponding 
\code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the inputs are (in)finite.
}
\examples{
x <- c(0, Inf, -Inf, NA, NaN)
is_finite(x)
is_infinite(x)
is_positive_infinity(x)
is_negative_infinity(x)
assert_all_are_finite(1:10)
assert_any_are_finite(c(1, Inf))
assert_all_are_infinite(c(Inf, -Inf))
assertive.base::dont_stop(assert_all_are_finite(c(0, Inf, -Inf, NA, NaN)))
}
\seealso{
\code{\link[base]{is.finite}}
}

