% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-set.R, R/is-set.R
\name{assert_is_set_equal}
\alias{assert_is_set_equal}
\alias{assert_is_subset}
\alias{assert_is_superset}
\alias{is_set_equal}
\alias{is_subset}
\alias{is_superset}
\title{Set comparisons}
\usage{
assert_is_set_equal(x, y)

assert_is_subset(x, y)

assert_is_superset(x, y)

is_set_equal(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y))

is_subset(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y))

is_superset(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y))
}
\arguments{
\item{x}{A vector.}

\item{y}{Another vector.}

\item{.xname}{Not intended to be used directly.}

\item{.yname}{Not intended to be used directly.}
}
\value{
The \code{is_*} functions return \code{TRUE} or \code{FALSE}.
The \code{assert_*} functions throw an error in the event of failure.
}
\description{
Checks on the contents of two vectors (ignoring the order of the elements).
}
\examples{
# Same contents, different order, returns TRUE
is_set_equal(1:5, 5:1)
# Different lengths
is_set_equal(1:5, 1:6)
# First vector contains values not in second vector
is_set_equal(1:5, c(1:4, 4))
# Second vector contains values not in first vector
is_set_equal(c(1:4, 4), 1:5)

# Is x a subset of y?
is_subset(1:4, 1:5)
is_subset(1:5, 1:4)

# Is x a superset of y?
is_superset(1:5, 1:4)
is_superset(1:4, 1:5)

# Errors are thrown in the event of failure
assert_is_set_equal(1:5, 5:1)
dont_stop(assert_is_set_equal(1:5, 1:6))

assert_is_subset(1:4, 1:5)
dont_stop(assert_is_subset(1:5, 1:4))

assert_is_superset(1:5, 1:4)
dont_stop(assert_is_superset(1:4, 1:5))
}
\seealso{
\code{\link{is_subset}}, \code{\link[base]{sets}},
\code{\link[sets]{set_is_equal}}
}

