% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-infinity-nan.R, R/is-infinity-nan.R
\name{assert_all_are_finite}
\alias{assert_all_are_finite}
\alias{assert_all_are_infinite}
\alias{assert_all_are_negative_infinity}
\alias{assert_all_are_positive_infinity}
\alias{assert_any_are_finite}
\alias{assert_any_are_infinite}
\alias{assert_any_are_negative_infinity}
\alias{assert_any_are_positive_infinity}
\alias{is_finite}
\alias{is_infinite}
\alias{is_negative_infinity}
\alias{is_positive_infinity}
\title{Are the inputs (in)finite?}
\usage{
assert_all_are_finite(x)

assert_any_are_finite(x)

assert_all_are_infinite(x)

assert_any_are_infinite(x)

assert_all_are_negative_infinity(x)

assert_any_are_negative_infinity(x)

assert_all_are_positive_infinity(x)

assert_any_are_positive_infinity(x)

is_finite(x)

is_infinite(x)

is_negative_infinity(x)

is_positive_infinity(x)
}
\arguments{
\item{x}{Input to check.}
}
\value{
\code{is_finite} wraps \code{is.finite}, showing the
names of the inputs in the answer. \code{is_infinite} works
likewise for \code{is.infinite}.  The \code{assert_*} functions
return nothing but throw an error if the corresponding
\code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the inputs are (in)finite.
}
\examples{
x <- c(0, Inf, -Inf, NA, NaN)
is_finite(x)
is_infinite(x)
is_positive_infinity(x)
is_negative_infinity(x)
assert_all_are_finite(1:10)
assert_any_are_finite(c(1, Inf))
assert_all_are_infinite(c(Inf, -Inf))
dont_stop(assert_all_are_finite(c(0, Inf, -Inf, NA, NaN)))
}
\seealso{
\code{\link[base]{is.finite}}
}

