% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R, R/deprecated_se.R
\name{assert_rows}
\alias{assert_rows}
\alias{assert_rows_}
\title{Raises error if predicate is FALSE for any row after applying
row reduction function}
\usage{
assert_rows(data, row_reduction_fn, predicate, ...,
  success_fun = success_continue, error_fun = error_stop)

assert_rows_(data, row_reduction_fn, predicate, ..., .dots,
  success_fun = success_continue, error_fun = error_stop)
}
\arguments{
\item{data}{A data frame}

\item{row_reduction_fn}{A function that returns a value for each row of
the provided data frame}

\item{predicate}{A function that returns FALSE when violated}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{success_fun}{Function to call if assertion passes. Defaults to
returning \code{data}.}

\item{error_fun}{Function to call if assertion fails. Defaults to printing
a summary of all errors.}

\item{.dots}{Use assert_rows_() to select columns using standard evaluation.}
}
\value{
By default, the \code{data} is returned if predicate assertion
        is TRUE and and error is thrown if not. If a non-default
        \code{success_fun} or \code{error_fun} is used, the return
        values of these function will be returned.
}
\description{
Meant for use in a data analysis pipeline, this function applies a
function to a data frame that reduces each row to a single value. Then,
a predicate function is applied to each of the row reduction values. If
any of these predicate applications yield FALSE, this function will raise
an error, effectively terminating the pipeline early. If there are no
FALSEs, this function will just return the data that it was supplied for
further use in later parts of the pipeline.
}
\details{
For examples of possible choices for the \code{success_fun} and
\code{error_fun} parameters, run \code{help("success_and_error_functions")}
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{

# returns mtcars
assert_rows(mtcars, num_row_NAs, within_bounds(0,2), mpg:carb)

library(magrittr)                    # for piping operator

mtcars \%>\%
  assert_rows(rowSums, within_bounds(0,2), vs:am)
  # anything here will run

\dontrun{
mtcars \%>\%
  assert_rows(rowSums, within_bounds(0,1), vs:am)
  # the assertion is untrue so
  # nothing here will run}

}
\seealso{
\code{\link{insist_rows}} \code{\link{assert}}
         \code{\link{verify}} \code{\link{insist}}
}
