% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.allele.R
\name{reduce.allele}
\alias{reduce.allele}
\title{Remove low variance alleles (dimensionality reduction)}
\usage{
reduce.allele(x, p = 0.95)
}
\arguments{
\item{x}{A returned object (a list) from the function read.genpop().}

\item{p}{A threshold of variance for the alleles to be removed. For example, if p = 0.95 (default setting), an allele occupied more than 95 percents across all the samples will be removed.}
}
\value{
This function return the same object as the function read.genpop() except that the number of columns in the matrix [[1]] is reduced and so is the locus name [[3]].
}
\description{
This function helps remove alleles that have low variance in the data set such that it can speed up further analyses for a large data set (e.g., > 10K SNPs).
}
\examples{
genin <- read.genpop(system.file("extdata/TinyGenepop.txt", package="assignPOP"))
reduce_infile <- reduce.allele(genin, p = 0.95)
#Change file 'TinyGenepop' to 'simGenepop' to get the example used in the tutorial.
}

