% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Execute a generator expression immediately, collecting yielded values.}
\usage{
run(
  expr,
  type = list(),
  ...,
  split_pipes = FALSE,
  debugR = FALSE,
  debugInternal = FALSE,
  trace = getOption("async.verbose")
)
}
\arguments{
\item{expr}{A generator expression, same as you would write in
\link{gen}.}

\item{type}{A value whose mode will determine the output vector mode (as
in \link{vapply}.)}

\item{...}{Undocumented.}

\item{split_pipes}{See \link{async}; defaults to FALSE.}

\item{debugR}{Will open a browser at the first and subsequent R
evaluations allowing single-stepping through user code.}

\item{debugInternal}{Will set a breakpoint at the implementation
level, allowing single-stepping through \code{async} package code.}

\item{trace}{a tracing function.}
}
\value{
If \code{expr} contains any \code{yield} calls, a vector of the
same mode as \code{type}; otherwise the return value of \code{expr}.
}
\description{
\code{run(expr)} with an expression directly writen, will parse that
expression as a coroutine, but then run it without pausing.
}
\details{
If the expression contains any calls to \code{yield()}, \code{run()} will
collect all the values passed to yield() and return a list. If the
expression contains a \code{yield()} but it is never called, \code{run()}
returns an empty list. If the expression does not contain a \code{yield}
at all, \code{run} returns the expression's final return value.

\code{run(expr)} is similar to \code{as.list(gen(expr))}, except \code{run(expr)}
evaluates its expression directly in the calling environment, while
\code{gen} creates a new enclosed environment to run in.

\code{run} is useful if you want to take advantage of coroutine language
extensions, such as using \code{for} loops over iterators, or using
\code{\link[=goto]{goto()}} in \code{switch} statements, in otherwise synchronous code. If
you want to collect a variable-length sequence of values but don't
need those features, using \link{collect} directly will have better
performance.
}
\examples{

run(type=0, {
  for (i in iterors::iseq(2, Inf, by=5)) {
    if (i \%\% 37 == 0) break
    else yield(i)
  }
})

}
