% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AtomFeed.R
\docType{class}
\name{AtomFeed}
\alias{AtomFeed}
\title{Atom feed class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an Atom feed
}
\description{
This class models an atom feed
}
\details{
AtomFeed
}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to create an Atom Feed
 }
 \item{\code{setId(id)}}{
   Set identifier
 }
 \item{\code{setUpdated(updated)}}{
   Set update date (object of class 'character' or 'POSIX')
 }
 \item{\code{addLink(link, rel, type)}}{
   Adds a link. Default \code{rel} value is set to "alternate". Default
   \code{type} value is set to "text/html"
 }
 \item{\code{delLink(link, rel, type)}}{
   Deletes a link
 }
 \item{\code{setSelfLink(link)}}{
   Sets a self-relation link
 }
 \item{\code{setAlternateLink(link, type)}}{
   Sets an alternate-relation link. Default type is "text/html"
 }
 \item{\code{setTitle(title)}}{
   Set title
 }
 \item{\code{setSubtitle(subtitle)}}{
   Set subtitle
 }
 \item{\code{addAuthor(author)}}{
   Adds an author, object of class \code{AtomAuthor}
 }
 \item{\code{delAuthor(author)}}{
   Deletes an author, object of class \code{AtomAuthor}
 }
 \item{\code{addContributor(contributor)}}{
   Adds a contributor, object of class \code{AtomContributor}
 }
 \item{\code{delContributor(contributor)}}{
   Deletes a contributor, object of class \code{AtomContributor}
 }
 \item{\code{setGenerator(generator, type)}}{
   Sets generator
 }
 \item{\code{setIcon(icon)}}{
   Sets icon
 }
 \item{\code{addCategory(term, scheme, label)}}{
   Adds a category
 }
 \item{\code{delCategory(term, scheme, label)}}{
   Deletes a category
 }
 \item{\code{addEntry(entry)}}{
   Adds an entry, object of class \code{AtomEntry}
 }
 \item{\code{delEntry(entry)}}{
   Deletes an entry, object of class \code{AtomEntry}
 }
}
}

\examples{
  #encoding
  atom <- AtomFeed$new()
  atom$setId("my-atom-feed")
  atom$setTitle("My Atom feed title")
  atom$setSubtitle("MyAtom feed subtitle")
  author1 <- AtomAuthor$new(
    name = "John Doe",
    uri = "http://www.atomxml.com/johndoe",
    email = "johndoe@atom4R.com"
  )
  atom$addAuthor(author1)
  author2 <- AtomAuthor$new(
    name = "John Doe's sister",
    uri = "http://www.atomxml.com/johndoesister",
    email = "johndoesister@atom4R.com"
  )
  atom$addAuthor(author2)
  contrib1 <- AtomContributor$new(
    name = "Contrib1",
    uri = "http://www.atomxml.com/contrib1",
    email = "contrib1@atom4R.com"
  )
  atom$addContributor(contrib1)
  contrib2 <- AtomContributor$new(
    name = "Contrib2",
    uri = "http://www.atomxml.com/contrib2",
    email = "contrib2@atom4R.com"
  )
  atom$addContributor(contrib2)
  atom$setIcon("https://via.placeholder.com/300x150.png/03f/fff?text=atom4R")
  atom$setSelfLink("http://example.com/atom.feed")
  atom$setAlternateLink("http://example.com/my-atom-feed")
  atom$addCategory("draft", "dataset")
  atom$addCategory("world", "spatial")
  atom$addCategory("fisheries", "domain")
  #add entry
  entry <- AtomEntry$new()
  entry$setId("my-atom-entry")
  entry$setTitle("My Atom feed entry")
  entry$setSummary("My Atom feed entry very comprehensive abstract")
  author1 <- AtomAuthor$new(
    name = "John Doe",
    uri = "http://www.atomxml.com/johndoe",
    email = "johndoe@atom4R.com"
  )
  entry$addAuthor(author1)
  author2 <- AtomAuthor$new(
    name = "John Doe's sister",
    uri = "http://www.atomxml.com/johndoesister",
    email = "johndoesister@atom4R.com"
  )
  entry$addAuthor(author2)
  contrib1 <- AtomContributor$new(
    name = "Contrib1",
    uri = "http://www.atomxml.com/contrib1",
    email = "contrib1@atom4R.com"
  )
  entry$addContributor(contrib1)
  contrib2 <- AtomContributor$new(
    name = "Contrib2",
    uri = "http://www.atomxml.com/contrib2",
    email = "contrib2@atom4R.com"
  )
  entry$addContributor(contrib2)
  entry$addCategory("draft", "dataset")
  entry$addCategory("world", "spatial")
  entry$addCategory("fisheries", "domain")
  atom$addEntry(entry)
  xml <- atom$encode()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{atom}
\keyword{feed}
\section{Super classes}{
\code{\link[atom4R:atom4RLogger]{atom4R::atom4RLogger}} -> \code{\link[atom4R:AtomAbstractObject]{atom4R::AtomAbstractObject}} -> \code{AtomFeed}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Identifier}

\item{\code{updated}}{Update date}

\item{\code{published}}{Publication date}

\item{\code{title}}{Title}

\item{\code{subtitle}}{Subtitle}

\item{\code{rights}}{Rights (license, use, ...)}

\item{\code{author}}{Author person}

\item{\code{contributor}}{Contributor person}

\item{\code{generator}}{Generator}

\item{\code{icon}}{Icon}

\item{\code{logo}}{Logo}

\item{\code{category}}{Category}

\item{\code{link}}{links}

\item{\code{entry}}{List of entries}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AtomFeed-new}{\code{AtomFeed$new()}}
\item \href{#method-AtomFeed-setId}{\code{AtomFeed$setId()}}
\item \href{#method-AtomFeed-setUpdated}{\code{AtomFeed$setUpdated()}}
\item \href{#method-AtomFeed-setPublished}{\code{AtomFeed$setPublished()}}
\item \href{#method-AtomFeed-addLink}{\code{AtomFeed$addLink()}}
\item \href{#method-AtomFeed-delLink}{\code{AtomFeed$delLink()}}
\item \href{#method-AtomFeed-setSelfLink}{\code{AtomFeed$setSelfLink()}}
\item \href{#method-AtomFeed-setAlternateLink}{\code{AtomFeed$setAlternateLink()}}
\item \href{#method-AtomFeed-setTitle}{\code{AtomFeed$setTitle()}}
\item \href{#method-AtomFeed-setSubtitle}{\code{AtomFeed$setSubtitle()}}
\item \href{#method-AtomFeed-setRights}{\code{AtomFeed$setRights()}}
\item \href{#method-AtomFeed-addAuthor}{\code{AtomFeed$addAuthor()}}
\item \href{#method-AtomFeed-delAuthor}{\code{AtomFeed$delAuthor()}}
\item \href{#method-AtomFeed-addContributor}{\code{AtomFeed$addContributor()}}
\item \href{#method-AtomFeed-delContributor}{\code{AtomFeed$delContributor()}}
\item \href{#method-AtomFeed-setGenerator}{\code{AtomFeed$setGenerator()}}
\item \href{#method-AtomFeed-setIcon}{\code{AtomFeed$setIcon()}}
\item \href{#method-AtomFeed-addCategory}{\code{AtomFeed$addCategory()}}
\item \href{#method-AtomFeed-delCategory}{\code{AtomFeed$delCategory()}}
\item \href{#method-AtomFeed-addEntry}{\code{AtomFeed$addEntry()}}
\item \href{#method-AtomFeed-delEntry}{\code{AtomFeed$delEntry()}}
\item \href{#method-AtomFeed-clone}{\code{AtomFeed$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="ERROR"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-ERROR'><code>atom4R::atom4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="INFO"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-INFO'><code>atom4R::atom4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="WARN"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-WARN'><code>atom4R::atom4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="logger"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-logger'><code>atom4R::atom4RLogger$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="addListElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-addListElement'><code>atom4R::AtomAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="contains"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-contains'><code>atom4R::AtomAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="createElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-createElement'><code>atom4R::AtomAbstractObject$createElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="decode"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-decode'><code>atom4R::AtomAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="delListElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-delListElement'><code>atom4R::AtomAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="encode"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-encode'><code>atom4R::AtomAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getClass"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getClass'><code>atom4R::AtomAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getClassName"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getClassName'><code>atom4R::AtomAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getNamespace"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getNamespace'><code>atom4R::AtomAbstractObject$getNamespace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getNamespaceDefinition"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getNamespaceDefinition'><code>atom4R::AtomAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getRootElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getRootElement'><code>atom4R::AtomAbstractObject$getRootElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getXmlElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getXmlElement'><code>atom4R::AtomAbstractObject$getXmlElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="isDocument"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-isDocument'><code>atom4R::AtomAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="isFieldInheritedFrom"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-isFieldInheritedFrom'><code>atom4R::AtomAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="print"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-print'><code>atom4R::AtomAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="save"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-save'><code>atom4R::AtomAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="setIsDocument"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-setIsDocument'><code>atom4R::AtomAbstractObject$setIsDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="validate"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-validate'><code>atom4R::AtomAbstractObject$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-new"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{AtomFeed}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setId"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setId}{}}}
\subsection{Method \code{setId()}}{
Set ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setId(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setUpdated"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setUpdated}{}}}
\subsection{Method \code{setUpdated()}}{
Set updated date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setUpdated(updated)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{updated}}{object of class \code{Date} or \code{POSIXt}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setPublished"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setPublished}{}}}
\subsection{Method \code{setPublished()}}{
Set published date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setPublished(published)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{published}}{object of class \code{Date} or \code{POSIXt}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-addLink"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-addLink}{}}}
\subsection{Method \code{addLink()}}{
Adds link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$addLink(link, rel = "alternate", type = "text/html")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}

\item{\code{rel}}{relation. Default is "alternate"}

\item{\code{type}}{type. Default is "text/html"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-delLink"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-delLink}{}}}
\subsection{Method \code{delLink()}}{
Deletes link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$delLink(link, rel = "alternate", type = "text/html")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}

\item{\code{rel}}{relation. Default is "alternate"}

\item{\code{type}}{type. Default is "text/html"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setSelfLink"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setSelfLink}{}}}
\subsection{Method \code{setSelfLink()}}{
Set self link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setSelfLink(link)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setAlternateLink"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setAlternateLink}{}}}
\subsection{Method \code{setAlternateLink()}}{
Set alternate link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setAlternateLink(link, type = "text/html")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}

\item{\code{type}}{type. Default is "text/html"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setTitle"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setTitle}{}}}
\subsection{Method \code{setTitle()}}{
Set title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setTitle(title, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{title}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setSubtitle"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setSubtitle}{}}}
\subsection{Method \code{setSubtitle()}}{
Set subtitle
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setSubtitle(subtitle, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subtitle}}{subtitle}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setRights"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setRights}{}}}
\subsection{Method \code{setRights()}}{
Set rights
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setRights(rights, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rights}}{rights}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-addAuthor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-addAuthor}{}}}
\subsection{Method \code{addAuthor()}}{
Adds author
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$addAuthor(author)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{author}}{object of class \link{AtomAuthor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-delAuthor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-delAuthor}{}}}
\subsection{Method \code{delAuthor()}}{
Deletes author
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$delAuthor(author)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{author}}{object of class \link{AtomAuthor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-addContributor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-addContributor}{}}}
\subsection{Method \code{addContributor()}}{
Adds contributor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$addContributor(contributor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contributor}}{object of class \link{AtomContributor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-delContributor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-delContributor}{}}}
\subsection{Method \code{delContributor()}}{
Deletes contributor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$delContributor(contributor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contributor}}{object of class \link{AtomContributor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setGenerator"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setGenerator}{}}}
\subsection{Method \code{setGenerator()}}{
Set generator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setGenerator(generator, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{generator}}{generator}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-setIcon"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-setIcon}{}}}
\subsection{Method \code{setIcon()}}{
Set icon
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$setIcon(icon)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{icon}}{icon}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-addCategory"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-addCategory}{}}}
\subsection{Method \code{addCategory()}}{
Adds category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$addCategory(value, term, scheme = NULL, label = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value}

\item{\code{term}}{term}

\item{\code{scheme}}{scheme}

\item{\code{label}}{label}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-delCategory"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-delCategory}{}}}
\subsection{Method \code{delCategory()}}{
Deletes category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$delCategory(value, term, scheme = NULL, label = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value}

\item{\code{term}}{term}

\item{\code{scheme}}{scheme}

\item{\code{label}}{label}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-addEntry"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-addEntry}{}}}
\subsection{Method \code{addEntry()}}{
Adds an entry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$addEntry(entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry}}{object of class \link{AtomEntry}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-delEntry"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-delEntry}{}}}
\subsection{Method \code{delEntry()}}{
Deletes an entry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$delEntry(entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry}}{object of class \link{AtomEntry}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomFeed-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AtomFeed-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomFeed$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
