% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query}
\alias{query}
\title{Fetch time-series historic data or forecasts from Axibase Time-Series Database.}
\usage{
query(metric, entity = NA, entity_group = NA, entity_expression = NA,
  tags = character(), selection_interval, end_time = NA,
  aggregate_interval = NA, aggregate_statistics = "Avg",
  interpolation = "None", export_type = "History", verbose = TRUE)
}
\arguments{
\item{metric}{Required string argument.
The name of the metric you want to get data for. 
For example, \code{metric = "disk_used_percent"}.
\cr
To obtain a list of metrics collected by ATSD use the
\code{\link{get_metrics}} function.}

\item{entity}{Optional string argument. 
The name of the entity you want to get data for.
If not provided, then data for all entities will be fetched
for the specified metric.
Obtain the list of entities and their tags with the
\code{\link{get_entities}} function.}

\item{entity_group}{Optional string argument. 
You could specify a group of entities and extract data 
for entities from this group.
For example, \code{entity_group = "HP Servers"}.}

\item{entity_expression}{Optional string argument.
Select entities matching particular name pattern and/or user-defined entity tags.
The syntax of the \code{entity_expression} argument is explained in the package vignette.
Type \code{browseVignettes(package = "atsd")} to see the vignette.}

\item{tags}{Optional string vector argument. 
List of user-defined series tags to filter the fetched time-series data, 
for example, 
\code{c("disk_name=sda1", "mount_point=/")}.}

\item{selection_interval}{Required string argument.
This is the time interval for which the data will be selected.
Specify it as "n-unit", where  
unit is a Second, Minute, Hour, Day, Week, Month, Quarter, or Year
and n is the number of units, for example, "3-Week" or "12-Hour".}

\item{end_time}{Optional string argument.
The end time of the selection interval, for example, 
\code{end_time = "date('2014-12-27')"}.
If not provided, the current time will be used. 
Specify the date and time, or use one of the supported expressions:
\url{https://github.com/axibase/atsd/blob/master/shared/calendar.md#keywords}.
For example, \code{'current_day'} would set the end of selection interval 
to 00:00:00 of the current day.}

\item{aggregate_interval}{Optional string argument.
The length of the aggregation interval. 
The period of produced time-series will be equal to the 
\code{aggregate_interval}.
The value for each period is computed by the 
\code{aggregate_statistics}
function applied to all samples of the original time-series within the period.
The format of the 
\code{aggregate_interval} is the same as for the 
\code{selection_interval} argument, for example, "1-Minute".}

\item{aggregate_statistics}{Optional string vector argument.
The statistic function used for aggregation.
List of available functions:
"Avg", "Min", "Max", "Sum", "Count", "StDev", "WAvg", "WTAvg", 
"Percentile 50", "Percentile 75", "Percentile 90", "Percentile 95", 
"Percentile 99", "Percentile 99.5", "Percentile 99.9".
Multiple values are supported, for example, c("Min", "Avg", "StDev").
The default value is "Avg".}

\item{interpolation}{Optional string argument
If aggregation is enabled, then the values for the periods without data 
will be computed by one of the following interpolation functions: 
"None", "Linear", "Step". The default value is "None".}

\item{export_type}{Optional string argument.
It can take one of two values: "History" or "Forecast". The default value is "History".
For example, \code{export_type = "Forecast"}.}

\item{verbose}{Optional boolean argument.
If \code{verbose = FALSE} then all console output will be suppressed.
By default, \code{verbose = TRUE}.}
}
\value{
The function returns a data frame. It could be empty if no data match your query
    or if your request could not be processed by ATSD server. In any case you will 
    get a console diagnostic message with a short description of the server response.
}
\description{
This function fetches time-series from ATSD and creates a data frame from it.
}
\details{
The function has only two required arguments:
    \code{metric} and \code{selection_interval}.
    \cr
    Type 
    \code{browseVignettes(package = "atsd")}
    to view the complete package documentation and usage examples.
}
\examples{
\dontrun{
# Create data frame which contains time series for the given metric 
# and all entities for the last 1 hour.
dfr <- query(metric = "disk_used_percent", selection_interval = "1-Hour")

dfr <- query( export_type = "Forecast",
              metric = "disk_used_percent",
              entity_group = "Linux",
              tags = c("mount_point=/boot", "file_system=/dev/sda1"),
              selection_interval = "1-Week",
              aggregate_statistics = c("Avg", "Min", "Max"),
              aggregate_interval = "1-Minute",
              interpolation = "Linear")
               
# Example of the end_time argument usage.
dfr <- query( metric = "cpu_usage",
              entity = "host-383",
              selection_interval = "1-Day",
              end_time = "date('2015-02-10 10:15:03')")
}
}
\seealso{
Visit
    \url{http://axibase.com/axibase-time-series-database/}
    for information about ATSD.
}
