% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_from_rmds.R
\name{att_from_rmd}
\alias{att_from_rmd}
\title{Get all dependencies from a Rmd file}
\usage{
att_from_rmd(
  path,
  temp_dir = tempdir(),
  warn = -1,
  encoding = getOption("encoding"),
  inside_rmd = FALSE,
  inline = TRUE
)
}
\arguments{
\item{path}{Path to a Rmd file}

\item{temp_dir}{Path to temporary script from purl vignette}

\item{warn}{-1 for quiet warnings with purl, 0 to see warnings}

\item{encoding}{Encoding of the input file; always assumed to be UTF-8 (i.e.,
this argument is effectively ignored).}

\item{inside_rmd}{Logical. Whether function is run inside a Rmd,
in case this must be executed in an external R session}

\item{inline}{Logical. Default TRUE. Whether to explore inline code for dependencies.}
}
\description{
Get all dependencies from a Rmd file
}
\examples{

dummypackage <- system.file("dummypackage",package = "attachment")
# browseURL(dummypackage)
att_from_rmd(path = file.path(dummypackage,"vignettes/demo.Rmd"))

}
