% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_remotes.R
\name{set_remotes_to_desc}
\alias{set_remotes_to_desc}
\title{Add Remotes field to DESCRIPTION based on your local installation}
\usage{
set_remotes_to_desc(path.d = "DESCRIPTION", stop.local = FALSE, clean = TRUE)
}
\arguments{
\item{path.d}{path to description file.}

\item{stop.local}{Logical. Whether to stop if package was installed from local source.
Message otherwise.}

\item{clean}{Logical. Whether to clean all existing remotes before run.}
}
\value{
Used for side effect. Adds Remotes field in DESCRIPTION file.
}
\description{
Add Remotes field to DESCRIPTION based on your local installation
}
\examples{
tmpdir <- tempdir()
file.copy(system.file("dummypackage", package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# Add remotes field if there are Remotes locally
att_amend_desc(dummypackage) \%>\%
  set_remotes_to_desc()
\dontrun{
# For your current package
att_amend_desc() \%>\%
  set_remotes_to_desc()
}
}
