% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_from_rscripts.R
\name{att_from_rscripts}
\alias{att_from_rscripts}
\title{Look for functions called with \code{::} and library/requires in folder of scripts}
\usage{
att_from_rscripts(path = "R", pattern = "*.[.](r|R)$", recursive = TRUE)
}
\arguments{
\item{path}{directory with R scripts inside or vector of R scripts}

\item{pattern}{pattern to detect R script files}

\item{recursive}{logical. Should the listing recurse into directories?}
}
\value{
vector of character of packages names found in the R script
}
\description{
Look for functions called with \code{::} and library/requires in folder of scripts
}
\examples{
dummypackage <- system.file("dummypackage",package = "attachment")
# browseURL(dummypackage)

att_from_rscripts(path = file.path(dummypackage, "R"))
att_from_rscripts(path = list.files(file.path(dummypackage, "R"), full.names = TRUE))
}
