% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_to_description.R
\name{att_amend_desc}
\alias{att_amend_desc}
\alias{att_to_desc_from_pkg}
\title{Amend DESCRIPTION with dependencies read from package code parsing}
\usage{
att_amend_desc(
  path = ".",
  path.n = "NAMESPACE",
  path.d = "DESCRIPTION",
  dir.r = "R",
  dir.v = "vignettes",
  dir.t = "tests",
  extra.suggests = NULL,
  pkg_ignore = NULL,
  document = TRUE,
  normalize = TRUE,
  inside_rmd = FALSE,
  must.exist = TRUE,
  check_if_suggests_is_installed = TRUE,
  update.config = FALSE,
  use.config = TRUE,
  path.c = "dev/config_attachment.yaml"
)

att_to_desc_from_pkg(
  path = ".",
  path.n = "NAMESPACE",
  path.d = "DESCRIPTION",
  dir.r = "R",
  dir.v = "vignettes",
  dir.t = "tests",
  extra.suggests = NULL,
  pkg_ignore = NULL,
  document = TRUE,
  normalize = TRUE,
  inside_rmd = FALSE,
  must.exist = TRUE,
  check_if_suggests_is_installed = TRUE,
  update.config = FALSE,
  use.config = TRUE,
  path.c = "dev/config_attachment.yaml"
)
}
\arguments{
\item{path}{path to the root of the package directory. Default to current directory.}

\item{path.n}{path to namespace file.}

\item{path.d}{path to description file.}

\item{dir.r}{path to directory with R scripts.}

\item{dir.v}{path to vignettes directory. Set to empty (dir.v = "") to ignore.}

\item{dir.t}{path to tests directory. Set to empty (dir.t = "") to ignore.}

\item{extra.suggests}{vector of other packages that should be added in Suggests (pkgdown, covr for instance)}

\item{pkg_ignore}{vector of packages names to ignore.}

\item{document}{Run function roxygenise of roxygen2 package}

\item{normalize}{Logical. Whether to normalize the DESCRIPTION file. See \code{\link[desc:desc_normalize]{desc::desc_normalize()}}}

\item{inside_rmd}{Logical. Whether function is run inside a Rmd,
in case this must be executed in an external R session}

\item{must.exist}{Logical. If TRUE then an error is given if packages do not exist
within installed packages. If NA, a warning.}

\item{check_if_suggests_is_installed}{Logical. Whether to require that packages in the Suggests section are installed.}

\item{update.config}{logical. Should the parameters used in this call be saved in the config file of the package}

\item{use.config}{logical. Should the command use the parameters from the config file to run}

\item{path.c}{character Path to the yaml config file where parameters are saved}
}
\value{
Update DESCRIPTION file.
}
\description{
Amend package DESCRIPTION file with the list of dependencies extracted from
R, tests, vignettes files.
att_to_desc_from_pkg() is an alias of att_amend_desc(),
for the correspondence with \code{\link[=att_to_desc_from_is]{att_to_desc_from_is()}}.
}
\details{
Your daily use is to run \code{att_amend_desc()}, as is.
You will want to run this function sometimes with some extra information like
\code{att_amend_desc(pkg_ignore = "x", update.config = TRUE)} if you have to update
the configuration file.
Next time \code{att_amend_desc()} will use these parameters from the configuration
file directly.
}
\examples{

# Run on an external "dummypackage" as an example
# For your local use, you do not have to specify the `path` as below
# By default, `att_amend_desc()` will run on the current working directory

# Create a fake package for the example
tmpdir <- tempfile(pattern = "description")
dir.create(tmpdir)
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")

# Update documentation and dependencies
att_amend_desc(path = dummypackage)

# You can look at the content of this external package
#' # browseURL(dummypackage)

# Update the config file with extra parameters
# We recommend that you store this code in a file in your "dev/" directory
# to run it when needed
att_amend_desc(path = dummypackage, extra.suggests = "testthat", update.config = TRUE)

# Next time, in your daily development
att_amend_desc(path = dummypackage)

# Clean after examples
unlink(tmpdir, recursive = TRUE)
}
