% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3.R
\name{plotD3}
\alias{plotD3}
\alias{plotD3_auditor}
\alias{plotD3.auditor_model_residual}
\alias{plotD3.auditor_model_halfnormal}
\alias{plotD3.auditor_model_evaluation}
\alias{plotD3.auditor_model_cooksdistance}
\title{Model Diagnostic Plots in D3 with r2d3 package.}
\usage{
plotD3(x, ...)

plotD3_auditor(x, ..., type = "residual")

\method{plotD3}{auditor_model_residual}(x, ..., type = "residual")

\method{plotD3}{auditor_model_halfnormal}(x, ..., type = "residual")

\method{plotD3}{auditor_model_evaluation}(x, ..., type = "residual")

\method{plotD3}{auditor_model_cooksdistance}(x, ..., type = "residual")
}
\arguments{
\item{x}{object of class \code{auditor_model_residual} (created with \code{\link{model_residual}} function),
\code{auditor_model_performance} (created with \code{\link{model_performance}} function),
\code{auditor_model_evaluation} (created with \code{\link{model_evaluation}} function),
\code{auditor_model_cooksdistance} (created with \code{\link{model_cooksdistance}} function),
or \code{auditor_model_halfnormal} (created with \code{\link{model_halfnormal}} function).}

\item{...}{other arguments dependent on the type of plot or additionl objects of classes \code{'auditor_model_residual',
'auditor_model_performance', 'auditor_model_evaluation', 'auditor_model_cooksdistance', 'auditor_model_halfnormal'}.}

\item{type}{the type of plot. Single character. Possible values:
\code{'acf', 'autocorrelation', 'cooksdistance', 'halfnormal','lift', 'prediction', 'rec', 'resiual',
'roc', 'rroc', 'scalelocation'}, (for detailed description see corresponding functions in see also section).}
}
\description{
This function provides several diagnostic plots for regression and classification models.
Provide object created with one of aduditor's computational functions, \code{\link{model_residual}},
\code{\link{model_cooksdistance}}, \code{\link{model_evaluation}}, \code{\link{model_performance}},
\code{\link{model_evaluation}}.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plotD3(mr_lm)
plotD3(mr_lm, type = "prediction")

hn_lm <- model_halfnormal(lm_audit)
plotD3(hn_lm)


}
\seealso{
\code{\link{plotD3_acf}, \link{plotD3_autocorrelation}, \link{plotD3_cooksdistance},
\link{plotD3_halfnormal}, \link{plotD3_residual}, \link{plotD3_lift},
\link{plotD3_prediction}, \link{plotD3_rec}, \link{plotD3_roc},
\link{plotD3_rroc}, \link{plotD3_scalelocation}}
}
