% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tsecdf.R
\name{plot_tsecdf}
\alias{plot_tsecdf}
\alias{plotTwoSidedECDF}
\title{Two-sided Cumulative Distribution Function}
\usage{
plot_tsecdf(
  object,
  ...,
  scale_error = TRUE,
  outliers = NA,
  residuals = TRUE,
  reverse_y = FALSE
)

plotTwoSidedECDF(
  object,
  ...,
  scale_error = TRUE,
  outliers = NA,
  residuals = TRUE,
  reverse_y = FALSE
)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{scale_error}{A logical value indicating whether ECDF should be scaled by proportions of positive and negative proportions.}

\item{outliers}{Number of outliers to be marked.}

\item{residuals}{A logical value indicating whether residuals should be marked.}

\item{reverse_y}{A logical value indicating whether values on y axis should be reversed.}
}
\value{
A ggplot object.
}
\description{
Cumulative Distribution Function for positive and negative residuals.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)
plot_tsecdf(mr_lm)
plot(mr_lm, type="tsecdf")

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
rf_audit <- audit(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(rf_audit)
plot_tsecdf(mr_lm, mr_rf, reverse_y = TRUE)


}
