% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_recall.R
\name{score_one_minus_recall}
\alias{score_one_minus_recall}
\title{One minus recall}
\usage{
score_one_minus_recall(object, cutoff = 0.5, data = NULL, y = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function
\code{\link[DALEX]{explain}} from the DALEX package.}

\item{cutoff}{Treshold value, which divides model predicted values (y_hat) to calculate confusion matrix.
By default it's \code{0.5}.}

\item{data}{New data that will be used to calcuate the score.
Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{y}{New y parameter will be used to calculate score.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
One minus recall
}
\examples{
library(DALEX)

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

# create an explainer
exp_glm <- explain(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# calculate score
score_one_minus_recall(exp_glm)


}
