% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebird-species.r
\name{ebird_species}
\alias{ebird_species}
\title{Lookup species in eBird taxonomy}
\usage{
ebird_species(x, type = c("scientific", "common", "code"))
}
\arguments{
\item{x}{character; species to look up, provided as scientific or
English common names, or a mixture of both. Case insensitive.}

\item{type}{character; whether to return scientific names (\code{scientific}),
English common names (\code{common}), or 6-letter eBird species codes (\code{code}).}
}
\value{
Character vector of species identified by scientific name, common
name, or species code.
}
\description{
Given a list of common or scientific names, check that they appear in the
official eBird taxonomy and convert them all to scientific names, common
names, or species codes. Un-matched species are returned as \code{NA}.
}
\examples{
# mix common and scientific names, case-insensitive
species <- c("Blackburnian Warbler", "Poecile atricapillus",
             "american dipper", "Caribou")
# note that species not in the ebird taxonomy return NA
ebird_species(species)
}
\seealso{
Other helpers: \code{\link{auk_getpath}},
  \code{\link{auk_version_date}}
}
\concept{helpers}
