% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputedReg.R
\name{imputedReg}
\alias{imputedReg}
\title{Make a multiple imputed model}
\usage{
imputedReg(fit, data = NULL, m = 20, seed = 1234, digits = 2, ...)
}
\arguments{
\item{fit}{An object of class lm or glm}

\item{data}{a data.frame}

\item{m}{Number of multiple imputations. The default is m=20.}

\item{seed}{An integer that is used as argument by the set.seed() for offsetting the random number generator.}

\item{digits}{Integer indicating the number of decimal place}

\item{...}{Further argument to be passed to mice}
}
\value{
An object of class "imputedReg" which inherits from the class "data.frame"
}
\description{
Make a multiple imputed model
}
\examples{
data(cancer,package="survival")
fit=glm(status~rx+sex+age+obstruct+nodes,data=colon,family="binomial")
imputedReg(fit)
\donttest{
library(survival)
fit=coxph(Surv(time,status)~rx+age+sex+nodes+obstruct+perfor,data=colon)
imputedReg(fit)
}
}
