% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{carve_subtree}
\alias{carve_subtree}
\title{Carve out branches to form a new tree.}
\usage{
carve_subtree(obj, char_arr)
}
\arguments{
\item{obj}{An object of class TreeHarp.}

\item{char_arr}{A vector of 1's and 0's indicating which nodes to keep. The
vector should have length equal to the number of nodes in obj.}
}
\value{
An object of class TreeHarp.
}
\description{
This functions keeps only the indicated nodes, returning a new sub-tree.
}
\details{
This returns an error if the sub-tree does not define a new tree.
}
\examples{
th3 <- list(a= c(2L,3L,4L), b=NULL, c=c(5L, 6L), d=7L, e=NULL, f=NULL, g=NULL)
carve_subtree(TreeHarp(th3), c(1,0,0,0,0,0,0))
st <- subtree_at(TreeHarp(th3), 4)
plot(st)
}
