% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_mean_slides.R
\name{g_eg_slide}
\alias{g_eg_slide}
\title{Plot mean values of EG}
\usage{
g_eg_slide(
  adsl,
  adeg,
  arm = "TRT01P",
  paramcd = "PARAM",
  subtitle = "Plot of Mean and 95\% Confidence Limits by Visit.",
  ...
)
}
\arguments{
\item{adsl}{ADSL data}

\item{adeg}{ADVS data}

\item{arm}{`"TRT01P"` by default}

\item{paramcd}{Which variable to use for plotting. By default `"PARAM"`}

\item{subtitle}{character scalar forwarded to g_lineplot}

\item{...}{|
Gets forwarded to `tern::g_lineplot()`.
This lets you specify additional arguments to `tern::g_lineplot()`}
}
\description{
Wrapper for `g_mean_general()`.
Requires filtering of the datasets (e.g. using SUFFIX in spec.yml)
}
\examples{
library(dplyr)

adeg_filtered <- eg_adeg \%>\% filter(
  PARAMCD == "HR"
)
plot_eg <- g_eg_slide(
  adsl = eg_adsl,
  adeg = adeg_filtered,
  arm = "TRT01P",
  paramcd = "PARAM",
  subtitle_add_unit = FALSE
) +
  ggplot2::theme(axis.text.x = ggplot2::element_text(angle = 45, hjust = 1))

generate_slides(plot_eg, paste0(tempdir(), "/g_eg.pptx"))
}
\author{
Stefan Thoma (`thomas7`)
}
