% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avar.r
\name{avlr}
\alias{avlr}
\title{Computes the Allan Variance Linear Regression estimator}
\usage{
avlr(x, qn = NULL, wn = NULL, rw = NULL, dr = NULL, ci = FALSE,
  B = 100, alpha = 0.05)
}
\arguments{
\item{x}{A \code{vec} of time series observations or an \code{imu} object.}

\item{qn}{A \code{vec} specifying on which scales the parameters of a Quantization Noise (QN) should be computed.}

\item{wn}{A \code{vec} specifying on which scales the parameters of a White Noise (WN) should be computed.}

\item{rw}{A \code{vec} specifying on which scales the parameters of a Random Wakk (RW) should be computed.}

\item{dr}{A \code{vec} specifying on which scales the parameters of a Drift (DR) should be computed.}

\item{ci}{A \code{boolean} to compute parameter confidence intervals.}

\item{B}{A \code{double} for the number of bootstrap replicates to compute the parameter confidence intervals.}

\item{alpha}{A \code{double} defining the level of the confidence interval (1 - `alpha`).}
}
\value{
avlr   A \code{list} that contains:
\itemize{
 \item{"estimates"}{The estimated value of the parameters.}
 \item{"implied_ad"}{The Allan deviation implied by the estimated parameters.}
 \item{"implied_ad_decomp"}{The Allan deviation implied by the estimated parameters for each individual model (if more than one is specified).}
 \item{"av"}{The \code{avar} object computed from the provided data.}
}
}
\description{
Estimate the parameters of time series models based on the Allan Variance Linear Regression (AVLR) approach
}
\examples{
\donttest{
set.seed(999)

N = 100000
Xt = rnorm(N) + cumsum(rnorm(N, 0, 3e-3))

av = avar(Xt)
plot(av)

fit = avlr(Xt, wn = 1:8, rw = 11:15)
fit
plot(fit, decomp = TRUE)
}
}
