% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avfintools.R
\name{ATR}
\alias{ATR}
\title{Average True Range}
\usage{
ATR(df, period, current = FALSE, mrprice = NULL, hideprints = TRUE)
}
\arguments{
\item{df}{Dataframe with price data.}

\item{period}{Calculation period in day for the true range}

\item{current}{If one wants to input the latest price point before data update}

\item{mrprice}{Most recent price;}

\item{hideprints}{if TRUE hides the print outs regarding the percentile within an ATR}
}
\value{
Returns a vector of ATR calculations in dataframe format. If current = TRUE, returns the most recent ATR as well as where price is in the context of the ATR
}
\description{
Returns the average true range as well as the relative price based on the ATR as a reference
}
\examples{
ATR(SPY15, 14)
ATR(SPY15, 14, current = TRUE, mrprice = tail(SPYdaily$close, 1) + 2)
}
