% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.aweek.R
\name{print.aweek}
\alias{print.aweek}
\alias{[.aweek}
\alias{c.aweek}
\title{The aweek class}
\usage{
\method{print}{aweek}(x, ...)

\method{[}{aweek}(x, i)

\method{c}{aweek}(..., recursive = FALSE, use.names = TRUE)
}
\arguments{
\item{x}{an object of class \code{aweek}}

\item{...}{a series of \code{aweek} objects (unused in \code{print.aweek()})}

\item{i}{index for subsetting an aweek object.}

\item{recursive, use.names}{parameters passed on to \code{\link[=unlist]{unlist()}}}
}
\value{
an object of class \code{aweek}
}
\description{
The method \code{c.aweek()} will always return an \code{aweek} object with
the same \code{week_start} attribute as the first object in the list. If the
first object is also a factor, then the output will be re-leveled. If
week-like characters are presented (e.g. "2019-W10-1"), then these are
assumed to have the same \code{week_start} as the first object.
}
\details{
The aweek class is a character or factor in the format YYYY-Www(-d) with a
"week_start" attribute containing an integer specifying which day of the ISO
8601 week each week should begin. This documentation shows how to print or
subset the object.
}
\examples{
d <- as.Date("2018-12-20") + 1:40
w <- date2week(d, week_start = "Sunday")
print(w)

# subsetting acts as normal
w[1:10]

# Combining multiple aweek objects
c(w[1], w[3], w[5])

# differing week_start days will default to the attribute of the first 
# aweek object
mon <- date2week(Sys.Date(), week_start = "Monday")
mon
c(w, mon)
c(mon, w)

# combining Dates will be coerced to aweek objects under the same rules
c(w, Sys.Date())

# truncated aweek objects will be un-truncated
w2 <- date2week(d[1:5], week_start = "Monday", floor_day = TRUE)
w2
c(w[1:5], w2)
}
\seealso{
\code{\link[=date2week]{date2week()}}, \code{\link[=as.Date.aweek]{as.Date.aweek()}}
}
