% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encryption.R
\name{get_encryption}
\alias{get_encryption}
\alias{put_encryption}
\alias{delete_encryption}
\title{Bucket encryption}
\usage{
get_encryption(bucket, ...)

put_encryption(bucket, algorithm = c("AES256", "KMS"), kms_arn = NULL, ...)

delete_encryption(bucket, ...)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{algorithm}{A character string specifying whether to use \dQuote{AES256} or \dQuote{KMS} encryption.}

\item{kms_arn}{If \code{algorithm = "KMS"}, a KMS ARN.}
}
\value{
For \code{get_encryption}: if encryption has never been set, the value is \code{NULL}. Otherwise, the encryption type is returned as a charater string. For \code{put_encryption} or \code{delete_encryption}: a logical \code{TRUE}
}
\description{
Get/Put/Delete bucket-level encryption settings.
}
\details{
\code{get_encryption} returns the default encryption of a bucket; \code{put_encryption} sets the default encryption. \code{delete_encryption} deletes the encryption status.
}
\examples{
\dontrun{
 # example bucket
 put_bucket("mybucket")

 # set and check encryption
 put_encryption("mybucket", "AES256")
 get_encryption("mybucket")

 # delete encryption
 delete_encryption("mybucket")
}

}
\references{
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html}{API Documentation}
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETencryption.html}{API Documentation}
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketDELETEencryption.html}{API Documentation}
}
