availability <- 
function(mast, v.set, dir.set, subset, digits=1, print=TRUE) {
### check availability for pairs of windspeed and direction - effective data period
	
	if(is.null(attr(mast, "call"))) stop(paste(substitute(mast), "is no mast object\n"))
	if(attr(mast, "call")$func!="createMast") stop(paste(substitute(mast), "is no mast object\n"))
	num.sets <- length(mast$sets)
	if(missing(v.set) && missing(dir.set)) v.set <- "all"
	if(!missing(v.set) && missing(dir.set)) dir.set <- v.set
	if(missing(v.set) && !missing(dir.set)) v.set <- dir.set
	
	if(!is.numeric(v.set)) if(!(length(v.set)==1 && any(v.set=="all"))) v.set <- match(v.set, names(mast$sets))
	if(any(is.na(v.set))) stop("'v.set' not found\n")
	if(!is.numeric(dir.set)) if(!(length(dir.set)==1 && any(dir.set=="all"))) dir.set <- match(dir.set, names(mast$sets))
	if(any(is.na(dir.set))) stop("'dir.set' not found\n")
	
	# subset
	num.samples <- length(mast$time.stamp)
	if(missing(subset)) subset <- c(NA, NA)
	if((!any(is.character(subset)) && !any(is.na(subset))) || length(subset)!=2) stop("Please specify 'subset' as vector of start and end time stamp\n")
	if(is.na(subset[1])) subset[1] <- as.character(mast$time.stamp[1])
	if(is.na(subset[2])) subset[2] <- as.character(mast$time.stamp[num.samples])
	start <- strptime(subset[1], "%Y-%m-%d %H:%M:%S")
	end <- strptime(subset[2], "%Y-%m-%d %H:%M:%S")
	if(is.na(start)) start <- strptime(subset[1], "%Y-%m-%d %H:%M")
	if(is.na(end)) end <- strptime(subset[2], "%Y-%m-%d %H:%M")
	if(is.na(start)) start <- strptime(subset[1], "%Y-%m-%d %H")
	if(is.na(end)) end <- strptime(subset[2], "%Y-%m-%d %H")
	if(is.na(start)) stop("Specified start time stamp in 'subset' not correctly formated\n")
	if(is.na(end)) stop("Specified end time stamp in 'subset' not correctly formated\n")
	if(start<mast$time.stamp[1] || start>mast$time.stamp[num.samples]) stop("Specified 'start' not in period\n")
	match.date <- difftime(mast$time.stamp, ISOdatetime(1,1,1,0,0,0), tz="GMT", units="days") - difftime(start, ISOdatetime(1,1,1,0,0,0), tz="GMT", units="days")
	start <- which(abs(as.numeric(match.date)) == min(abs(as.numeric(match.date))))
	if(end<mast$time.stamp[1] || end>mast$time.stamp[num.samples]) stop("Specified 'end' not in period\n")
	match.date <- difftime(mast$time.stamp, ISOdatetime(1,1,1,0,0,0), tz="GMT", units="days") - difftime(end, ISOdatetime(1,1,1,0,0,0), tz="GMT", units="days")
	end <- which(abs(as.numeric(match.date)) == min(abs(as.numeric(match.date))))
	
	num.samples <- length(mast$time.stamp[start:end])
	start.year <- mast$time.stamp[start:end]$year[1]+1900
	end.year <- mast$time.stamp[start:end]$year[num.samples]+1900
	start.month <- mast$time.stamp[start:end]$mon[1]+1
	end.month <- mast$time.stamp[start:end]$mon[num.samples]+1
	start.day <- mast$time.stamp[start:end]$mday[1]
	end.day <- mast$time.stamp[start:end]$mday[num.samples]
	if(start.year==end.year) num.months <- end.month-start.month+1
	if(start.year!=end.year) num.months <- 13-start.month+end.month + 12*(end.year-start.year-1)
	period.days <- as.numeric(mast$time.stamp[start:end][num.samples]-mast$time.stamp[start:end][1])
	
	if(all(v.set!="all")) {
		if(length(v.set)==1 && length(dir.set)==1) { # one set
			if(v.set<0 || v.set>num.sets) stop("'v.set' not found\n")
			if(dir.set<0 || dir.set>num.sets) stop("'dir.set' not found\n")
			if(is.null(mast$sets[[v.set]]$data$v.avg)) stop("'v.set' does not contain average wind speed data\n")
			if(is.null(mast$sets[[dir.set]]$data$dir.avg)) stop("'dir.set' does not contain average wind direction data\n")
			if(any(attr(mast$sets[[v.set]]$data, "clean")=="v.avg") && any(attr(mast$sets[[dir.set]]$data, "clean")=="dir.avg")) cat("Set(s) not cleaned - cleaning of wind speed v.avg and wind direction dir.avg using 'clean' is recommended to avoid overestimated availability\n")
			avail <- list(availabilityInt(mast$sets[[v.set]]$data$v.avg[start:end], mast$sets[[dir.set]]$data$dir.avg[start:end], mast$time.stamp[start:end], start.year, start.month, num.months, period.days, digits))
			if(v.set==dir.set) names(avail) <- names(mast$sets)[v.set]
			else names(avail) <- paste(names(mast$sets)[v.set], "_", names(mast$sets)[dir.set], sep="")
		} else { # list of sets
			if(length(v.set)==length(dir.set)) {
				avail <- total <- NULL
				uncleaned <- 0
				
				for(s in 1:length(v.set)) { # x/x
					if(v.set[s]<0 || v.set[s]>num.sets) stop("'v.set' not found\n")
					if(dir.set[s]<0 || dir.set[s]>num.sets) stop("'dir.set' not found\n")
					if(is.null(mast$sets[[v.set[s]]]$data$v.avg)) stop("'v.set' does not contain average wind speed data\n")
					if(is.null(mast$sets[[dir.set[s]]]$data$dir.avg)) stop("'dir.set' does not contain average wind direction data\n")
					if(any(attr(mast$sets[[v.set[s]]]$data, "clean")=="v.avg") && any(attr(mast$sets[[dir.set[s]]]$data, "clean")=="dir.avg")) cat("Set(s) not cleaned - cleaning of wind speed v.avg and wind direction dir.avg using 'clean' is recommended to avoid overestimated availability\n")
					
					avail.s <- availabilityInt(mast$sets[[v.set[s]]]$data$v.avg[start:end], mast$sets[[dir.set[s]]]$data$dir.avg[start:end], mast$time.stamp[start:end], start.year, start.month, num.months, period.days, digits)
					if(!is.null(avail)) avail[[length(avail)+1]] <- avail.s
					if(is.null(avail)) avail <- list(avail.s)
					if(any(attr(mast$sets[[v.set[s]]]$data, "clean")=="v.avg") && any(attr(mast$sets[[v.set[s]]]$data, "clean")=="dir.avg")) uncleaned <- uncleaned+1
					if(v.set[s]==dir.set[s]) names(avail)[s] <- names(mast$sets)[v.set[s]]
					else names(avail)[s] <- paste(names(mast$sets)[v.set[s]], "_", names(mast$sets)[dir.set[s]], sep="")
				}
			} else if(length(v.set)!=length(dir.set) && (length(v.set)==1 || length(dir.set)==1)) { # x/1 or 1/x
				avail <- total <- NULL
				uncleaned <- 0
				
				if(length(v.set)==1) {
					for(s in 1:length(dir.set)) {
						if(v.set<0 || v.set>num.sets) stop("'v.set' not found\n")
						if(dir.set[s]<0 || dir.set[s]>num.sets) stop("'dir.set' not found\n")
						if(is.null(mast$sets[[v.set]]$data$v.avg)) stop("'v.set' does not contain average wind speed data\n")
						if(is.null(mast$sets[[dir.set[s]]]$data$dir.avg)) stop("'dir.set' does not contain average wind direction data\n")
						if(any(attr(mast$sets[[v.set]]$data, "clean")=="v.avg") && any(attr(mast$sets[[dir.set[s]]]$data, "clean")=="dir.avg")) cat("Set(s) not cleaned - cleaning of wind speed v.avg and wind direction dir.avg using 'clean' is recommended to avoid overestimated availability\n")
						
						avail.s <- availabilityInt(mast$sets[[v.set]]$data$v.avg[start:end], mast$sets[[dir.set[s]]]$data$dir.avg[start:end], mast$time.stamp[start:end], start.year, start.month, num.months, period.days, digits)
						if(!is.null(avail)) avail[[length(avail)+1]] <- avail.s
						if(is.null(avail)) avail <- list(avail.s)
						if(any(attr(mast$sets[[v.set]]$data, "clean")=="v.avg") && any(attr(mast$sets[[v.set]]$data, "clean")=="dir.avg")) uncleaned <- uncleaned+1
						if(v.set==dir.set[s]) names(avail)[s] <- names(mast$sets)[v.set]
						else names(avail)[s] <- paste(names(mast$sets)[v.set], "_", names(mast$sets)[dir.set[s]], sep="")
					}
				} else {
					for(s in 1:length(v.set)) {
						if(v.set[s]<0 || v.set[s]>num.sets) stop("'v.set' not found\n")
						if(dir.set<0 || dir.set>num.sets) stop("'dir.set' not found\n")
						if(is.null(mast$sets[[v.set[s]]]$data$v.avg)) stop("'v.set' does not contain average wind speed data\n")
						if(is.null(mast$sets[[dir.set]]$data$dir.avg)) stop("'dir.set' does not contain average wind direction data\n")
						if(any(attr(mast$sets[[v.set[s]]]$data, "clean")=="v.avg") && any(attr(mast$sets[[dir.set]]$data, "clean")=="dir.avg")) cat("Set(s) not cleaned - cleaning of wind speed v.avg and wind direction dir.avg using 'clean' is recommended to avoid overestimated availability\n")
						
						avail.s <- availabilityInt(mast$sets[[v.set[s]]]$data$v.avg[start:end], mast$sets[[dir.set]]$data$dir.avg[start:end], mast$time.stamp[start:end], start.year, start.month, num.months, period.days, digits)
						if(!is.null(avail)) avail[[length(avail)+1]] <- avail.s
						if(is.null(avail)) avail <- list(avail.s)
						if(any(attr(mast$sets[[v.set[s]]]$data, "clean")=="v.avg") && any(attr(mast$sets[[v.set[s]]]$data, "clean")=="dir.avg")) uncleaned <- uncleaned+1
						if(v.set[s]==dir.set) names(avail)[s] <- names(mast$sets)[v.set[s]]
						else names(avail)[s] <- paste(names(mast$sets)[v.set[s]], "_", names(mast$sets)[dir.set], sep="")
					}
				}
			}
		}
	} else { # all sets
		set.index <- NULL
		for(s in 1:num.sets) if(!is.null(mast$sets[[s]]$data$v.avg) && !is.null(mast$sets[[s]]$data$dir.avg)) set.index <- append(set.index, s)
		if(is.null(set.index)) stop("No pairs of wind speed and wind direction data found")
		avail <- total <- NULL
		uncleaned <- 0
		
		for(s in 1:length(set.index)) {
			avail.s <- availabilityInt(mast$sets[[set.index[s]]]$data$v.avg[start:end], mast$sets[[set.index[s]]]$data$dir.avg[start:end], mast$time.stamp[start:end], start.year, start.month, num.months, period.days, digits)
			if(!is.null(avail)) avail[[length(avail)+1]] <- avail.s
			if(is.null(avail)) avail <- list(avail.s)
			if(any(attr(mast$sets[[set.index[s]]]$data, "clean")=="v.avg") && any(attr(mast$sets[[set.index[s]]]$data, "clean")=="dir.avg")) uncleaned <- uncleaned+1
		}
		names(avail) <- names(mast$sets)[set.index]
		if(uncleaned>0) cat(paste(uncleaned, "of", length(set.index), "sets were not cleaned - cleaning of wind speed v.avg and wind direction dir.avg using 'clean' is recommended to avoid overestimated availability\n"))
	}
	
	attr(avail, "call") <- list(func="availability", mast=deparse(substitute(mast)), v.set=v.set, dir.set=dir.set, subset=subset, digits=digits, print=print)
	
	if(print) printObject(avail)
	invisible(avail)
}
