% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_densitree.R
\name{plot_densitree}
\alias{plot_densitree}
\title{Draw multiple trees on top of one another.}
\usage{
plot_densitree(phylos, ...)
}
\arguments{
\item{phylos}{one or more phylogenies, must be of class \code{multiPhylo}}

\item{...}{options to be passed to \code{phangorn}'s
\link[phangorn]{densiTree} function}
}
\value{
nothing. Will produce a plot.
}
\description{
Draw multiple trees on top of one another.
}
\examples{
if (is_beast2_installed()) {
   out <- bbt_run(
    get_babette_path("anthus_aco.fas"),
    mcmc = create_test_mcmc(chain_length = 10000)
  )
  plot_densitree(out$anthus_aco_trees)
}
}
\author{
Richèl J.C. Bilderbeek
}
