% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify.R
\name{sparsify.with.gspar}
\alias{sparsify.with.gspar}
\title{Extract Satuluri et al's (2011) G-spar backbone}
\usage{
sparsify.with.gspar(U, s, class = "original", narrative = FALSE)
}
\arguments{
\item{U}{An unweighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \code{\link{Matrix}}; (2) an edgelist in the form of a two-column dataframe; (3) an \code{\link{igraph}} object; (4) a \code{\link{network}} object.}

\item{s}{numeric: Proportion of edges to retain, 0 < s < 1; smaller values yield sparser graphs}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "sparseMatrix", "igraph", "network", "edgelist").
If "original", the backbone graph returned is of the same class as \code{U}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An unweighted, undirected, unipartite graph of class \code{class}.
}
\description{
\code{sparsify.with.gspar} is a wrapper for \code{\link[=sparsify]{sparsify()}} that extracts the G-spar backbone described by Satuluri et al. (2011).
It is equivalent to \code{sparsify(escore = "jaccard", normalize = "none", filter = "proportion", umst = FALSE)}.
}
\examples{
U <- igraph::sbm.game(60, matrix(c(.75,.25,.25,.25,.75,.25,.25,.25,.75),3,3), c(20,20,20))
plot(U) #A hairball
sparse <- sparsify.with.gspar(U, s = 0.4, narrative = TRUE)
plot(sparse) #Clearly visible communities
}
\references{
{Satuluri, V., Parthasarathy, S., & Ruan, Y. (2011, June). Local graph sparsification for scalable clustering. In Proceedings of the 2011 ACM SIGMOD International Conference on Management of data (pp. 721-732). \doi{10.1145/1989323.1989399}}
}
