% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_disp}
\alias{set_disp}
\title{Specify Prior for Dispersion or Standard Deviation}
\usage{
set_disp(mod, mean)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{mean}{Mean value for the exponential prior.
In Poisson and binomial models, can be set to 0.}
}
\value{
A \code{bage_mod} object
}
\description{
Specify the mean of prior for the dispersion
parameter (in Poisson and binomial models) or the
standard deviation parameter (in normal models.)
}
\details{
The dispersion or mean parameter has an exponential
distribution with mean \eqn{\mu},

\deqn{p(\xi) = \frac{1}{\mu}\exp\left(\frac{-\xi}{\mu}\right).}

In Poisson and binomial models,
\code{mean} can be set to \code{0}, implying
that the dispersion term is also \code{0}.
In normal models, \code{mean} must be non-negative.

If \code{set_disp()} is applied to
a fitted model, it 'unfits'
the model, deleting existing estimates.
}
\examples{
mod <- mod_pois(injuries ~ age:sex + ethnicity + year,
                data = nzl_injuries,
                exposure = popn)
mod
mod |> set_disp(mean = 0.1)
mod |> set_disp(mean = 0)
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} Specify a
model for rates, probabilities, or means
\item \code{\link[=set_prior]{set_prior()}} Specify prior for a term
\item \code{\link[=set_n_draw]{set_n_draw()}} Specify the number of draws
\item \code{\link[=is_fitted]{is_fitted()}} Test whether a model is fitted
}
}
