% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_var_sexgender}
\alias{set_var_sexgender}
\title{Specify Sex or Gender Variable}
\usage{
set_var_sexgender(mod, name)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{name}{The name of the sex or gender variable.}
}
\value{
A \code{"bage_mod"} object
}
\description{
Specify which variable (if any) represents sex or gender.
Functions \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}},
and \code{\link[=mod_norm]{mod_norm()}} try to infer the sex/gender variable
from variable names, but do not always get it right.
}
\details{
In an R \code{\link{formula}}, a 'variable' is different
from a 'term'. For instance,

\code{~ gender + region + gender:region}

contains variables \code{gender} and \code{region},
and terms \code{gender}, \code{region}, and \code{gender:region}.

If \code{set_var_sexgender()} is applied to
a fitted model, it 'unfits'
the model, deleting existing estimates.
}
\examples{
## rename 'sex' variable to something unexpected
injuries2 <- nzl_injuries
injuries2$biological_sex <- injuries2$sex

## mod_pois does not recognize sex variable
mod <- mod_pois(injuries ~ age * biological_sex + year,
                data = injuries2,
                exposure = popn)
mod

## so we set the sex variable explicitly
mod |>
  set_var_sexgender(name = "biological_sex")
}
\seealso{
\itemize{
\item \code{\link[=set_var_age]{set_var_age()}} Set age variable
\item \code{\link[=set_var_time]{set_var_time()}} Set time variable
\item \code{\link[=is_fitted]{is_fitted()}} Test whether model is fitted
\item internally, \strong{bage} uses \code{\link[poputils:find_var_sexgender]{poputils::find_var_sexgender()}}
to locate sex or gender variables
\item internally, \strong{bage} uses \code{\link[poputils:find_label_female]{poputils::find_label_female()}}
to locate female categories within a sex or gender variable
\item internally, \strong{bage} uses \code{\link[poputils:find_label_male]{poputils::find_label_male()}}
to locate male categories within a sex or gender variable
}
}
