% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesamesim.R
\docType{data}
\name{sesamesim}
\alias{sesamesim}
\title{Simulated Sesame Street Data}
\format{A data frame with 240 rows and 9 variables.}
\usage{
data(sesamesim)
}
\description{
A simulated data set inspired by the Sesame Street data set from:
Stevens, J. P. (1996). Applied Multivariate Statistics for the Social
Sciences. Mahwah NJ: Lawrence Erlbaum.
}
\details{
The number knowledge of children is measured before watching Sesame Street,
after one year, and a follow up measurement after two years.

\describe{
  \item{sex}{Sex of the child; 1 = boy, 2 = girl}
  \item{site}{Site of the child's origin; 1 = disadvantaged inner city, 2 =
   advantaged suburban , 3 = advantaged rural,
  4 = disadvantaged rural, 5 = disadvantaged Spanish speaking}
  \item{setting}{Setting in which the child watches Sesame Street; 1 = at
  home, 2 = at school}
  \item{age}{Age of the child in months}
  \item{viewenc}{Whether or not the child is encouraged to watch Sesame
  Street; 0 = no, 1 = yes}
  \item{peabody}{Peabody mental age score of the child; the higher the
  score the higher the mental age}
  \item{prenumn}{score on a numbers test before watching Sesame Street for
  a year}
  \item{postnumb}{score on a numbers test after watching Sesame Street for
  a year}
  \item{funumb}{follow up numbers test score measured one year after
  postnumb}
}
}
\keyword{datasets}
