% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continue.mcmc.R
\name{continue.mcmc.bairt}
\alias{continue.mcmc.bairt}
\title{Continue MCMC for the Estimation of the Two-Parameter or
Three-Parameter Normal Ogive Model}
\usage{
\method{continue.mcmc}{bairt}(mcmclist, initial.value = NULL,
  c.prior = NULL, iter = NULL, burning = NULL, thin = NULL,
  parts = NULL, ...)
}
\arguments{
\item{mcmclist}{A \emph{bairt} class object (\emph{mcmc.2pnob} or
\emph{mcmc.3pnob}).}

\item{initial.value}{List with initial values.}

\item{c.prior}{A two dimensional vector which defines the beta prior
distribution of guessing parameters. The default is a non-informative prior,
\emph{Beta(1,1)}.}

\item{iter}{Total number of iterations.}

\item{burning}{Number of burnin iterations.}

\item{thin}{The thinning interval between consecutive observations.}

\item{parts}{Number of splits for MCMC chain.}

\item{...}{Further arguments.}
}
\value{
An \emph{mcmc.2pnob or mcmc.3pnob} object.
}
\description{
This is a function for \emph{bairt} objects. You can use \emph{continue.mcmc}
for continue the MCMC the Two-Parameter or Three-Parameter
normal ogive item response model.
}
\details{
If any argument (\emph{final.values}, \emph{c.prior}, \emph{iter},
\emph{burning}, \emph{thin} or \emph{parts}) is NULL, \emph{continue.mcmc}
take the value of the \emph{mcmclist}.
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 100, burning = 0)

# continue the  MCMC for the Two-Parameter Normal Ogive Model
model21 <- continue.mcmc(model2, iter = 100, burning = 0)

\donttest{
# For all examinees of the data MathTest
# Three-Parameter Normal Ogive Model
# selection of the prior for 5 response options
cprior <- select.c.prior(5)
modelAll3 <- mcmc.3pnob(MathTest, iter = 1000, burning = 0,
                    c.prior = cprior)

#continue the  MCMC for the Three-Parameter Normal Ogive Model
# form 1
initialValues2 <- final.values.mcmc(modelAll3)
modelAll31 <- mcmc.3pnob(MathTest, initial.value = initialValues2,
                     iter = 2000, burning = 0, c.prior = cprior)
# form 2
modelAll32 <- continue.mcmc(modelAll3, iter = 2000, burning = 0)
}

## End(Not run)


}
\references{
Johnson, V. E., & Albert, J. H. (1999). Ordinal Data Modeling.
New York: Springer.

A.A.  Beguin, A, A & Glas, C.A.W. (2001). MCMC Estimation and
Some Model-Fit Analysis of Multidimensional IRT Models. Psychometrika,
66, 541-562.
}
\seealso{
\code{\link{mcmc.2pnob}} and \code{\link{mcmc.3pnob}}.
}
\author{
Javier Martínez
}
