% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizations.R
\name{FnPCA}
\alias{FnPCA}
\title{Creating PCA plots with logit(fn) estimates}
\usage{
FnPCA(obj, log_kdeg = FALSE)
}
\arguments{
\item{obj}{Object contained within output of \code{bakRFit}. So, either Fast_Fit (MLE implementation fit),
Stan_Fit (MCMC implementation fit), or Hybrid_Fit (Hybrid implementation fit)}

\item{log_kdeg}{Boolean; if TRUE, then log(kdeg) estimates used for PCA rather than logit(fn). Currently
only compatible with Fast_Fit}
}
\value{
A ggplot object.
}
\description{
This function creates a 2-component PCA plot using logit(fn) estimates.
}
\examples{
\donttest{
# Simulate data for 500 genes and 2 replicates
sim <- Simulate_bakRData(500, nreps = 2)

# Fit data with fast implementation
Fit <- bakRFit(sim$bakRData)

# Fn PCA
FnPCA(Fit$Fast_Fit)

# log(kdeg) PCA
FnPCA(Fit$Fast_Fit, log_kdeg = TRUE)

}
}
