% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pba.R
\name{pba}
\alias{pba}
\title{Principal Balance Analysis}
\usage{
pba(x, alpha = NA)
}
\arguments{
\item{x}{A matrix with rows as samples (N) and columns as components (D).}

\item{alpha}{A double. Defines a hyper-parameter used
by the Box-Cox transformation to approximate log-ratio
variance in the presence of zeros. Skip with NA.}
}
\value{
A \code{pba} object.
}
\description{
This function performs a principal balance analysis using the
 hierarchical clustering of components method described
 by Pawlowsky-Glahn et al. in "Principal balances"
 from the CoDaWork 2011 proceedings.
}
\details{
This resultant object contains the original data, the serial
 binary partition, the principal balances, and the fractional
 variances per balance. Use \code{predict} to deploy the
 \code{pba} model on new data.
}
\examples{
library(balance)
data(iris)
train <- iris[1:50,1:4]
test <- iris[51:150,1:4]
model <- pba(train)
predict(model, test)
plot(model, test)

}
\author{
Thom Quinn
}
