% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_apc.R
\name{checkConvergence}
\alias{checkConvergence}
\title{Check apc object, whether MCMC has converged}
\usage{
checkConvergence(x, info = FALSE, level = 2, auto = FALSE)
}
\arguments{
\item{x}{An apc object}

\item{info}{logical; print more information}

\item{level}{level of check; 1 uses point point estimation, 2 uses upper C.I.}

\item{auto}{logical; should be TRUE if called automatically from \code{\link{bamp}}
#'}
}
\value{
logical; TRUE if check is fine.
}
\description{
This functions uses Gelman and Rubin's R to check convergence for all main parameters. 
All parameters should have R<1.1. 
\code{\link{bamp}} runs at least four MCMC chains by default (more if parallel is more than four).
}
\examples{
\dontrun{
data(apc)
model <- bamp(cases, population, age="rw1", period="rw1", cohort="rw1", periods_per_agegroup = 5)
checkConvergence(model)
}
}
