% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initBanterModel.R
\name{initBanterModel}
\alias{initBanterModel}
\title{Initialize BANTER model}
\usage{
initBanterModel(x)
}
\arguments{
\item{x}{a data.frame of events. Every row is a unique event. Must have 
columns named \code{event.id} and \code{species}. All other 
columns will be used as predictor variables for the BANTER event classifier 
model.}
}
\value{
a \code{\link{banter_model}} object without any detector models.
}
\description{
Initialize a BANTER model with event data.
}
\note{
Values in the column \code{species} are passed through the
  \code{\link{make.names}} function on creation to ensure they 
  don't include invalid characters.
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
bant.mdl

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
