% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBanterModel.R
\name{runBanterModel}
\alias{runBanterModel}
\title{Run BANTER Model}
\usage{
runBanterModel(x, ntree, sampsize = 1)
}
\arguments{
\item{x}{a \code{\link{banter_model}} object.}

\item{ntree}{number of trees.}

\item{sampsize}{number or fraction of samples to use in each tree.}
}
\value{
a \code{\link{banter_model}} object with the complete BANTER model.
}
\description{
Build full event classifier model
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
# add all detector models
bant.mdl <- addBanterDetector(
  bant.mdl, train.data$detectors, 
  ntree = 50, sampsize = 1, num.cores = 1
)
# run BANTER event model
bant.mdl <- runBanterModel(bant.mdl, ntree = 1000, sampsize = 1)
summary(bant.mdl)

}
\references{
Rankin, S., Archer, F., Keating, J. L., Oswald, J. N., 
  Oswald, M. , Curtis, A. and Barlow, J. (2017), Acoustic classification 
  of dolphins in the California Current using whistles, echolocation clicks,
  and burst pulses. Marine Mammal Science 33:520-540. doi:10.1111/mms.12381
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
