% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology.R, R/bso-phenology.R
\name{phenology}
\alias{phenology}
\alias{bso_phenology}
\title{Central function to calculate a phenology}
\usage{
phenology(
  .model,
  .data = NULL,
  .dates = NULL,
  .win = NULL,
  .ext = "tif",
  .onset = NULL,
  .diapause = NULL,
  .mortality = NULL,
  .submodels = c("onset", "diapause", "mortality", "development"),
  .setup_only = FALSE,
  .stations = NULL,
  .storage = NULL,
  .quiet = FALSE,
  ...
)

bso_phenology(
  .model = "bso",
  .data = NULL,
  .dates = NULL,
  .win = NULL,
  .ext = "tif",
  .onset = NULL,
  .diapause = NULL,
  .mortality = NULL,
  .submodels = c("onset", "diapause", "mortality", "development"),
  .setup_only = FALSE,
  .stations = NULL,
  .storage = NULL,
  .quiet = FALSE,
  ...
)
}
\arguments{
\item{.model}{A phenology model or a model name (see \code{\link[=model]{model()}},
\code{\link[=model_combine]{model_combine()}}).}

\item{.data}{Data that will be passed to the model. It can be one of the following:
\itemize{
\item Character string: The raster data will be loaded from the path specified.
The files have to be named like the respective model inputs.
\item Named list: Each element contains the input data according to its name.
\item Data frame (station data): Should have the columns \code{date} and \code{station}
(name of the station). Additional columns have to be named like the
respective model inputs.
\item Additionally, data can be passed through the \dots argument.
}

Look at the model application manuals to find out which inputs are required
by a specific model: \code{\link{model.bso.apply}}, \code{\link{model.phenips.apply}}, \code{\link{model.rity.apply}}, \code{\link{model.chapy.apply}}, \code{\link{model.joensson.apply}}, \code{\link{model.lange.apply}}, \code{\link{model.phenips_clim.apply}}.}

\item{.dates}{Vector of dates that the data should be restricted to.}

\item{.win}{SpatExtent to set a window (area of interest) if \code{.data} is a
path to load the raster data from.}

\item{.ext}{Extension of the files that should be used if \code{.data} is a path
to load the raster data from.}

\item{.onset, .diapause, .mortality}{Pass custom or precalculated phenological
events to the model. See \code{\link{create_events}} to find out how to create events
manually. Alternatively, the return value of \code{\link[=get_onset_rst]{get_onset_rst()}},
\code{\link[=get_diapause_rst]{get_diapause_rst()}} or \code{\link[=get_mortality_rst]{get_mortality_rst()}}
could be used (with \code{as_doy = FALSE}) to extract the respective phenological event from another phenology.
In that case, that phenology must match the temporal and spatial extent of the
other inputs.}

\item{.submodels}{Character vector. Specifies which submodels should be
calculated. Can be a subset of
\code{c('onset', 'diapause', 'mortality', 'development')}.}

\item{.setup_only}{If \code{TRUE} only the inputs will be preprocessed without
calculating any submodels. The preprocessed data can be used as input for
other \code{\link[=phenology]{phenology()}} calls and can be accessed via \code{\link[=get_input_data]{get_input_data()}}.}

\item{.stations}{Assign stations to the phenology. See \code{\link[=stations_create]{stations_create()}} for details.}

\item{.storage}{If set, the path specified here will be used to save the
(intermediate) results. If \code{phenology()} is called successively with a
growing amount of data, the calculations will continue where they stopped.
This can save calculation time especially for large raster inputs. Note that
this will only work of raster inputs and if \code{terra::sources()} is not empty.
Otherwise the results of the calculations will be saved but successive
calculations are not possible. If no input data is passed, the phenology
will be loaded from the storage.}

\item{.quiet}{If \code{TRUE}, messages are suppressed.}

\item{...}{Parameters that will be passed to the model. Must be named according
to the model inputs. See \code{.data} for alternative ways to pass data to the model.}
}
\value{
A phenology as a list. Look \link[=analyse.phenology]{here} to find out how
a phenology can be analysed. It is not recommended to access the list elements directly.
}
\description{
Calculate a phenology (or its subparts) with a specific model.
}
\section{Functions}{
\itemize{
\item \code{bso_phenology()}: As BSO works a bit different than the other models, a seperate
phenology function is implemented for this model. Note that while the
onset and the development submodels are needed to be taken from BSO,
the diapause and the mortality submodels are compatible with other models.

The function returns a BSO phenology as a list. Look \link[=analyse.phenology.bso]{here} to find out how
a BSO phenology can be analysed. It is not recommended to access the list elements directly.
To be able to use the functions that are
available for phenology objects returned by \code{\link[=phenology]{phenology()}}, call \code{\link[=bso_translate_phenology]{bso_translate_phenology()}}.

}}
\examples{
\donttest{
# calculate phenology
p <- phenology('phenips-clim', barrks_data())

# plot calculated generations
gens <- get_generations_rst(p)
terra::plot(gens)
}
}
\seealso{
\code{\link{model.bso.apply}}, \code{\link{model.phenips.apply}}, \code{\link{model.rity.apply}}, \code{\link{model.chapy.apply}}, \code{\link{model.joensson.apply}}, \code{\link{model.lange.apply}}, \code{\link{model.phenips_clim.apply}}
}
