/*
 * Decompiled with CFR 0.152.
 */
package CustomLogging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SuperSimpleFormatter
extends Formatter {
    private String lineSeparator = "\n";

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append(logRecord.getSourceClassName());
        } else {
            stringBuffer.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(logRecord.getSourceMethodName());
        }
        stringBuffer.append(this.lineSeparator);
        String string = this.formatMessage(logRecord);
        if (logRecord.getLevel().getLocalizedName().equals("STDERR")) {
            stringBuffer.append("ERROR: ");
        }
        stringBuffer.append(string);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

