% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitDensity.R
\name{splitDensity}
\alias{splitDensity}
\title{splitDensity}
\usage{
splitDensity(
  trees,
  data,
  bandWidth = NULL,
  panelScale = NULL,
  scaleFactor = NULL,
  display = "histogram"
)
}
\arguments{
\item{trees}{A list of trees created using the trees function.}

\item{data}{Data frame containing variables from the model.}

\item{bandWidth}{Bandwidth used for density calculation. If not provided, is estimated from the data.}

\item{panelScale}{If TRUE, the default, relative scaling is calculated separately for each panel.
If FALSE, relative scaling is calculated globally.
@param scaleFactor A scaling factor to scale the height of the ridgelines relative to the spacing between them.
 A value of 1 indicates that the maximum point of any ridgeline touches the baseline right above,
 assuming even spacing between baselines.}

\item{scaleFactor}{A numerical value to scale the plot.}

\item{display}{Choose how to display the plot. Either histogram, facet wrap, ridges
or display both the split value and density of the predictor by using dataSplit.}
}
\value{
A faceted group of density plots
}
\description{
Density plots of the split value for each variable.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 splitDensity(trees = trees_data, data = df, display = 'ridge')
}

}
