% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProximity.R
\name{plotProximity}
\alias{plotProximity}
\title{plotProximity}
\usage{
plotProximity(
  matrix,
  pal = rev(colorspace::sequential_hcl(palette = "Blues 2", n = 100)),
  limit = NULL
)
}
\arguments{
\item{matrix}{A matrix of proximities created by the proximityMatrix function}

\item{pal}{A vector of colours to show proximity scores, for use with scale_fill_gradientn.}

\item{limit}{Specifies the fit range for the color map for proximity scores.}
}
\value{
A plot of proximity values.
}
\description{
Plot a proximity matrix
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6],
   df[, 1],
   ntree = 5,
   keeptrees = TRUE,
   nskip = 10,
   ndpost = 10)
 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 # Create Proximity Matrix
 mProx <- proximityMatrix(trees = trees_data, reorder = TRUE, normalize = TRUE, iter = 1)
 # Plot
 plotProximity(matrix = mProx)
}
}
