% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mltools_one_hot.R
\name{one_hot}
\alias{one_hot}
\title{One Hot Encode}
\source{
https://cran.r-project.org/web/packages/mltools
}
\usage{
one_hot(
  dt,
  cols = "auto",
  sparsifyNAs = FALSE,
  naCols = FALSE,
  dropCols = TRUE,
  dropUnusedLevels = FALSE
)
}
\arguments{
\item{dt}{A data.table}

\item{cols}{Which column(s) should be one-hot-encoded? DEFAULT = "auto" encodes all unordered factor columns}

\item{sparsifyNAs}{Should NAs be converted to 0s?}

\item{naCols}{Should columns be generated to indicate the present of NAs? Will only apply to factor columns with at least one NA}

\item{dropCols}{Should the resulting data.table exclude the original columns which are one-hot-encoded?}

\item{dropUnusedLevels}{Should columns of all 0s be generated for unused factor levels?}
}
\value{
data.table object  From the input data, a data frame in which categorical variables have been one-hot encoded is returned.
}
\description{
One-Hot-Encode unordered factor columns of a data.table
}
\details{
One-hot-encoding converts an unordered categorical vector (i.e. a factor) to multiple binarized vectors where each binary vector of
1s and 0s indicates the presence of a class (i.e. level) of the of the original vector.
}
\examples{

library(data.table)

dt <- data.table(
  ID = 1:4,
  color = factor(c("red", NA, "blue", "blue"), levels=c("blue", "green", "red"))
)

one_hot(dt)
one_hot(dt, sparsifyNAs=TRUE)
one_hot(dt, naCols=TRUE)
one_hot(dt, dropCols=FALSE)
one_hot(dt, dropUnusedLevels=TRUE)

}
