% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterfall_plot.R
\name{waterfall_plot}
\alias{waterfall_plot}
\title{Waterfall Plot}
\usage{
waterfall_plot(
  object,
  obs_num = NULL,
  title = NULL,
  geo.unit = NULL,
  geo.id = NULL,
  obs_name = NULL
)
}
\arguments{
\item{object}{Enter the name of the object that contains the model's contributions
and results obtained using the Explain function.}

\item{obs_num}{observation number (only one)}

\item{title}{plot title}

\item{geo.unit}{The name of the stratum variable in the BARP model as a character.}

\item{geo.id}{Enter a single value of the stratum variable as a character.}

\item{obs_name}{Enter the name of the vector containing observation IDs or names.}
}
\value{
The function returns a waterfall plot.
\item{plot_out}{The waterfall plot of the observation at index \code{obs_num}.}
}
\description{
The \code{waterfall_plot} function is a bar chart that displays the positive and
negative contributions across sequential data points, visualizing how each
variable's contributions change for a single observation.
}
\examples{
\donttest{
## Friedman data
set.seed(2025)
n <- 200
p <- 5
X <- data.frame(matrix(runif(n * p), ncol = p))
y <- 10 * sin(pi* X[ ,1] * X[,2]) +20 * (X[,3] -.5)^2 + 10 * X[ ,4] + 5 * X[,5] + rnorm(n)

## Using dbarts 
model <- dbarts::bart (X, y, keeptrees = TRUE, ndpost = 200)

# prediction wrapper function
pfun <- function (object, newdata) {
 predict(object, newdata)
 }
 
# Calculate shapley values
model_exp <-  Explain(model, X = X, pred_wrapper=pfun)

# Waterfall plot of 100th observation
waterfall_plot(model_exp, obs_num=100) 
}

}
