% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchingStats.R
\name{FIP}
\alias{FIP}
\title{Pitching: Fielding Independent Pitching (FIP)}
\usage{
FIP(dat = NULL, Fangraphs = FALSE, NA_to_zero = TRUE,
  Sep.Leagues = FALSE)
}
\arguments{
\item{dat}{A data frame you would wish to calculate. The data frame must have the same column names found in
The \code{Lahman} package or the Chadwick Bureau GitHub repository.}

\item{Fangraphs}{If TRUE the function will download wOBA values from Fangraphs. If FALSE the function will use the internal
formula adapted from Tom Tango's original wOBA formula. Note, the internal formula is typically identical to Fangraphs and
does not require an external download. If not specified, the default is set to FALSE.}

\item{NA_to_zero}{If TRUE this will replace NAs with 0 for years that certain stats were not counted. For example, sacrifice hits
were not a counted statistic until 1954, therefore we are technically unable to calculate wOBA for any player prior to 1954.
The default is set to TRUE. Even though this is bad practice mathematically, many in the sabermetrics community accept the practice.
If FALSE, the wOBA calculation will return NaN for years with missing data.}

\item{Sep.Leagues}{If TRUE the algorithm will calculate different run environments for the National and American leagues. Grouping
the leagues can solve problems introduced by the designated hitter and hitting pitchers. It also serves to further isolate for
park factors between the American and National leagues. The default for this argument is FALSE.}
}
\description{
Find the FIP for all pitchers with one or strike outs in a particular season.
Required fields from the Pitching table are "BB", "HBP", "SO", and "IPouts."
}
\examples{

data("Pitching2016")
head(Pitching2016)

Pitching2016$FIP <- FIP(Pitching2016, Fangraphs=FALSE, NA_to_zero=TRUE, Sep.Leagues=FALSE)

}
\seealso{
Other Pitching functions: \code{\link{BB_9}},
  \code{\link{HR_9}}, \code{\link{H_9}}, \code{\link{IP}},
  \code{\link{K_9}}, \code{\link{LOB_pct}},
  \code{\link{WHIP}}
}
\keyword{FIP}
\keyword{fielding}
\keyword{independent}
\keyword{pitching}
