% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_statcast_leaderboards.R
\name{statcast_leaderboards}
\alias{statcast_leaderboards}
\title{\strong{Query Baseball Savant Leaderboards}}
\usage{
statcast_leaderboards(
  leaderboard = "exit_velocity_barrels",
  year = 2020,
  abs = 50,
  min_pa = "q",
  min_pitches = 100,
  min_throws = 100,
  min_field = "q",
  min_run = 0,
  player_type = "batter",
  fielding_type = "player",
  oaa_position = "",
  oaa_roles = "",
  team = "",
  arsenal_type = "n_",
  run_type = "raw",
  min2b = 5,
  min3b = 0,
  position = "",
  bats = "",
  hand = ""
)
}
\arguments{
\item{leaderboard}{The type of leaderboard to retrieve, input as a string. Current
options include exit_velocity_barrels, expected_statistics, pitch_arsenal,
outs_above_average, directional_oaa, catch_probability, pop_time, sprint_speed, and
running_splits_90_ft, arm_strength.}

\item{year}{The season for which you want data.}

\item{abs}{The minimum number of batted balls. Applies only to exit_velocity_barrels
leaderboards.}

\item{min_pa}{Minimum number of plate appearances. Can be a number or 'q' for qualified batters.}

\item{min_pitches}{Minimum number of pitches thrown.}

\item{min_throws}{Minimum number of throwing opportunities.}

\item{min_field}{Minimum number of fieding opportunities.}

\item{min_run}{Minimum number of running opportunities.}

\item{player_type}{One of either 'batter' or pitcher. For the expected_statistics
leaderboard, 'batter-team' and 'pitcher-team' are also available.}

\item{fielding_type}{One of either 'player' or 'team'.}

\item{oaa_position}{Can be either the number position of a player or 'if' or 'of' for
position categories.}

\item{oaa_roles}{Can be either the number position of a player or 'if' or 'of' for
position categories.}

\item{team}{An abbreviation for a team. Can be left blank.}

\item{arsenal_type}{One of either 'n_', 'avg_spin', or 'avg_speed'.}

\item{run_type}{One of either 'percent' or 'raw'.}

\item{min2b}{The minimum number of throwing attempts to second base.}

\item{min3b}{The minimum number of throwing attempts to third base.}

\item{position}{The numeric position of the player. For DH use 10. Can be left blank.}

\item{bats}{The handedness of the batter. One of 'R' or 'L'. Can be left blank.}

\item{hand}{The handedness of the pitcher. One of 'R' or 'L'. Can be left blank.}
}
\value{
Returns a tibble of Statcast leaderboard data with the following columns (for leaderboard: 'exit_velocity_barrels'):\tabular{ll}{
   col_name \tab types \cr
   year \tab numeric \cr
   last_name \tab character \cr
   first_name \tab character \cr
   player_id \tab integer \cr
   attempts \tab integer \cr
   avg_hit_angle \tab numeric \cr
   anglesweetspotpercent \tab numeric \cr
   max_hit_speed \tab numeric \cr
   avg_hit_speed \tab numeric \cr
   fbld \tab numeric \cr
   gb \tab numeric \cr
   max_distance \tab integer \cr
   avg_distance \tab integer \cr
   avg_hr_distance \tab integer \cr
   ev95plus \tab integer \cr
   ev95per-swing \tab numeric \cr
   ev95percent \tab numeric \cr
   barrels \tab integer \cr
   brl_percent \tab numeric \cr
   brl_pa \tab numeric \cr
}
}
\description{
This function allows you to read leaderboard data from BaseballSavant directly into R as data frame.
}
\details{
oaa_roles argument:
30 = 1B - Straight Up
31 = 1B - Towards 1B/2B Hole
32 = 1B - Close to Line
40 = 2B - Straight Up
41 = 2B - Shaded Towards 2B Bag
42 = 2B - Towards 1B/2B Hole
43 = 2B - Behind First Basemen
46 = 2B - Up the Middle
60 = SS - Straight Up
61 = SS - Towards 3B/SS Hole
62 = SS - Shaded Towards 2B Bag
64 = SS - Up the Middle
50 = 3B - Straight Up
51 = 3B - Close to Line
52 = 3B - Towards 3B/SS Hole
77 = LF - Close to Line
71 = LF - Leaning Left
70 = LF - Straight Up
72 = LF - Leaning Right
78 = LF - LF Gap
87 = CF - LF Gap
81 = CF - Leaning Left
82 = CF - Leaning Right
89 = CF - RF Gap
98 = RF - RF Gap
91 = RF - Leaning Left
90 = RF - Straight Up
92 = RF - Leaning Right
99 = RF - Close to Line
}
\examples{
\donttest{
  try(statcast_leaderboards(leaderboard = "expected_statistics", year = 2018))
  try(statcast_leaderboards(leaderboard = "arm_strength", year = 2020))
}
}
