% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.R
\name{interim_postpred}
\alias{interim_postpred}
\alias{interim_postpred,TwoStageBasket-method}
\title{Interim analysis based on the posterior predictive probability}
\usage{
interim_postpred(design, ...)

\S4method{interim_postpred}{TwoStageBasket}(
  design,
  n,
  n1,
  r1,
  lambda,
  weight_mat,
  globalweight_fun = NULL,
  globalweight_params,
  prob_futstop = 0.1,
  prob_effstop = 0.9,
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}

\item{r1}{Vector of responses after the interim analysis.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_mat}{The matrix with all weights. Automatically calculated
in the functions to which \code{interim_postpred} is passed.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{prob_futstop}{Probability cut-off for stopping for futility.}

\item{prob_effstop}{Probability cut-off for stopping for efficacy.}
}
\value{
A vector with a length equal to the number of baskets with
elements -1, 0 or 1 where -1 means stop for futility, 0 means continuation
and 1 means stop for efficacy.
}
\description{
Conducts an interim analysis based on the posterior predictive probability.
}
\details{
\code{interim_postpred} conducts an interim analysis with possible
stop for efficacy and futility based on the posterior predictive probability.
If the posterior predictive probability is less than \code{prob_fustop} the
basket is  stopped for futility, if the posterior predictive probability is
greater than \code{prob_effstop} the basket is stopped for efficacy. If
\code{prob_fustop = 0} or \code{prob_effstop = 1} then no futility-stop and
no efficacy stop is possible, respectively.

The function is generally not called by the user but passed to another
function such as \code{\link{toer}} and \code{\link{pow}} to specify which
interim analysis is conducted.
}
\section{Methods (by class)}{
\itemize{
\item \code{interim_postpred(TwoStageBasket)}: Interim analysis based on the posterior
predictive probabilty for two-stage basket designs.

}}
\examples{
design <- setupTwoStageBasket(k = 3, p0 = 0.2)
toer(design, n = 20, n1 = 10, lambda = 0.99, interim_fun = interim_postpred,
  weight_fun = weights_fujikawa)
}
