% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Problem.R
\name{addProblem}
\alias{addProblem}
\alias{Problem}
\alias{removeProblems}
\title{Define Problems for Experiments}
\usage{
addProblem(
  name,
  data = NULL,
  fun = NULL,
  seed = NULL,
  cache = FALSE,
  reg = getDefaultRegistry()
)

removeProblems(name, reg = getDefaultRegistry())
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Unique identifier for the problem.}

\item{data}{[\code{ANY}]\cr
Static problem part. Default is \code{NULL}.}

\item{fun}{[\code{function}]\cr
The function defining the stochastic problem part.
The static part is passed to this function with name \dQuote{data} and the \code{\link{Job}}/\code{\link{Experiment}}
is passed as \dQuote{job}.
Therefore, your function must have the formal arguments \dQuote{job} and \dQuote{data} (or dots \code{...}).
If you do not provide a function, it defaults to a function which just returns the data part.}

\item{seed}{[\code{integer(1)}]\cr
Start seed for this problem. This allows the \dQuote{synchronization} of a stochastic
problem across algorithms, so that different algorithms are evaluated on the same stochastic instance.
If the problem seed is defined, the seeding mechanism works as follows:
(1) Before the dynamic part of a problem is instantiated,
the seed of the problem + [replication number] - 1 is set, i.e. the first
replication uses the problem seed. (2) The stochastic part of the problem is
instantiated. (3) From now on the usual experiment seed of the registry is used,
see \code{\link{ExperimentRegistry}}.
If \code{seed} is set to \code{NULL} (default), the job seed is used to instantiate the problem and
different algorithms see different stochastic instances of the same problem.}

\item{cache}{[\code{logical(1)}]\cr
If \code{TRUE} and \code{seed} is set, problem instances will be cached on the file system.
This assumes that each problem instance is deterministic for each combination of hyperparameter setting
and each replication number.
This feature is experimental.}

\item{reg}{[\code{\link{ExperimentRegistry}}]\cr
Registry. If not explicitly passed, uses the last created registry.}
}
\value{
[\code{Problem}]. Object of class \dQuote{Problem} (invisibly).
}
\description{
Problems may consist of up to two parts: A static, immutable part (\code{data} in \code{addProblem})
and a dynamic, stochastic part (\code{fun} in \code{addProblem}).
For example, for statistical learning problems a data frame would be the static problem part while
a resampling function would be the stochastic part which creates problem instance.
This instance is then typically passed to a learning algorithm like a wrapper around a statistical model
(\code{fun} in \code{\link{addAlgorithm}}).

This function serialize all components to the file system and registers the problem in the \code{\link{ExperimentRegistry}}.

\code{removeProblem} removes all jobs from the registry which depend on the specific problem.
\code{reg$problems} holds the IDs of already defined problems.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
tmp = makeExperimentRegistry(file.dir = NA, make.default = FALSE)
addProblem("p1", fun = function(job, data) data, reg = tmp)
addProblem("p2", fun = function(job, data) job, reg = tmp)
addAlgorithm("a1", fun = function(job, data, instance) instance, reg = tmp)
addExperiments(repls = 2, reg = tmp)

# List problems, algorithms and job parameters:
tmp$problems
tmp$algorithms
getJobPars(reg = tmp)

# Remove one problem
removeProblems("p1", reg = tmp)

# List problems and algorithms:
tmp$problems
tmp$algorithms
getJobPars(reg = tmp)
}
\seealso{
\code{\link{Algorithm}}, \code{\link{addExperiments}}
}
